<?php

namespace App\Channels;

use Illuminate\Notifications\Notification;

class WhatsappChannel
{
    /**
     * Send the given notification.
     *
     * @param  mixed  $notifiable
     * @param  \Illuminate\Notifications\Notification  $notification
     * @return void
     */
    public function send($notifiable, Notification $notification)
    {
        $message = $notification->toWhatsapp($notifiable);

        $message->send();

       // Or use dryRun() for testing to send it, without sending it for real.
        $message->dryRun()->send();
    }
}
