<?php

namespace App\Channels;


use GuzzleHttp\Client;
use App\Http\Controllers\API\WhatsappGateway;
use App\Models\WhatsappGateway\WhatsappGatewayGeneral;

class WhatsappMessage
{

    protected string $apikey;
    protected string $to;
    protected string $from;
    protected string $message;
    protected string $dryrun = 'no';
    protected string $baseUrl;
    protected string $endpoint;

    /**
     * Create a new notification instance.
     */
    public function __construct()
    {
        $this->apikey = env('API_CLIENT_MESSAGE');
        $this->baseUrl = config('wa-griyanet.server_url');
        $this->endpoint = WhatsappGateway::SEND_MESSAGE;
        $this->from = WhatsappGatewayGeneral::first()->whatsapp_number_notification;
    }

    public function to($to): self
    {
        $this->to = $to;
        return $this;
    }

    public function from($from): self
    {
        $this->from = $from;
        return $this;
    }

    public function message($message = ''): self
    {
        $this->message = $message;
        return $this;
    }

    public function dryrun($dry = 'yes'): self
    {
        $this->dryrun = $dry;
        return $this;
    }

    public function send(): mixed
    {
        if (!$this->from || !$this->to || strlen($this->message) <= 0) {
            throw new \Exception('Whatsapp format not correct.');
        }

        $send_wa = $this->endpoint . '?sender=' . $this->from . '&number=' . $this->to . '&message=' . $this->message;
        $client = new Client([
            'base_uri' => 'https://' . $this->baseUrl,
            'verify' => false
        ]);

        try {
            $response = $client->post($send_wa, [
                'headers' => [
                    'Authorization' => 'Bearer ' . env('API_CLIENT_MESSAGE'),
                    'Accept' => 'application/json'
                ],
            ]);
            return [
                'status_code' => $response->getStatusCode(),
                'result' => json_decode($response->getBody()->getContents(), true)
            ];
        } catch (\GuzzleHttp\Exception\ClientException $e) {
            return [
                'status_code' => $e->getResponse()->getStatusCode(),
                'result' => json_decode($e->getResponse()->getBody()->getContents(), true)
            ];
        }
    }
}
