<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Jobs\Isolirs\CustomerPaketsIsolirJob;

class ProcessAutoIsolir extends Command
{
    protected $signature = 'isolir:process-auto-isolir';
    protected $description = 'Processing auto isloir';

    public function handle()
    {
        if (cache()->get('processing_auto_isolir')) {
            $this->warn('Processing auto isolir is already running');
            return Command::FAILURE;
        }

        cache()->put('processing_auto_isolir', true, 60); // Lock for 60 minutes

        try {

            $this->info('Processing auto isolir...');
            dispatch(new CustomerPaketsIsolirJob())->onQueue('default');
            cache()->forget('processing_auto_isolir');
            return Command::SUCCESS;
        } catch (\Exception $e) {
            cache()->forget('processing_auto_isolir');
            $this->error("Error processing auto isolir: " . $e->getMessage());
            return Command::FAILURE;
        }
    }
}
