<?php

namespace App\Handler;

use Illuminate\Http\Request;
use App\Models\Billings\Order;
use App\Models\PaymentGateway;
use App\Models\Billings\Invoice;
use Illuminate\Support\Facades\Log;
use Spatie\WebhookClient\Models\WebhookCall;
use App\Services\Payments\PartialPaymentService;
use Spatie\WebhookClient\Jobs\ProcessWebhookJob;

//The class extends "ProcessWebhookJob" class as that is the class
//that will handle the job of processing our webhook before we have
//access to it.

class ProcessTripayWebhook extends ProcessWebhookJob
{
    public WebhookCall $webhookCall;
    public function __construct(WebhookCall $webhookCall)
    {
        $this->webhookCall = $webhookCall;
    }

    public function handle(Request $request, PartialPaymentService $partialPaymentService)
    {
        Log::warning('Tripay payment proccessed...');
        $dat = json_decode($this->webhookCall, true);
        $data = $dat['payload'];

        $invoice = Invoice::whereInvoiceNumber($data['merchant_ref'])->where('status', '!=', 'paid')->first();

        if (!$invoice) {
            Log::info('Invoice ' . $data['merchant_ref'] . ' not found.');
            return false;
        }

        $ammountReceived = $data['amount_received'] ?? $data['total_amount'] - $data['total_fee'] + $data['fee_merchant'];
        Log::info('Ammount Received ' .$ammountReceived);
        $proccessPayment = $partialPaymentService->processPartialPayment(
            $invoice,
            $ammountReceived,
            'tripay',
            null,
            'Tripay'
        );

        Log::info($proccessPayment['message']);

        //Acknowledge you received the response
        http_response_code(200);
    }
}
