<?php

namespace App\Handler;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Spatie\WebhookClient\WebhookConfig;
use Spatie\WebhookClient\Exceptions\InvalidConfig;
use Spatie\WebhookClient\SignatureValidator\SignatureValidator;

class TripaySignature implements SignatureValidator
{
    public function isValid(Request $request, WebhookConfig $config): bool
    {
        Log::info('Tripay login');
        $signature = $request->header($config->signatureHeaderName);
        if (!$signature) {
            Log::info('Invalid signature screet');
            return false;
        }

        $callBackEvent = $request->header('X-Callback-Event');
        if ($callBackEvent != 'payment_status') {
            Log::info('Invalid callback event');
            return false;
        }

        //Private Key
        $signingSecret = $config->signingSecret;
        if (empty($signingSecret)) {
            Log::info('Signing screet not set');
           // throw InvalidConfig::signingSecretNotSet();
        }

        $computedSignature = hash_hmac('sha256', $request->getContent(), $signingSecret);
        return hash_equals($signature, $computedSignature);
    }
}
