<?php

namespace App\Http\Requests\Billings;

use Illuminate\Support\Facades\Validator;

class AddDiscountRequest
{
    /**
     * Validate and create a newly registered customer.
     *
     * @param  array<string, string>  $input
     */
    public function validate(array $input, $remainingAmount): array
    {
       // $value = 1000;
        Validator::make($input, [
            'discount' => ['required', 'numeric', 'min:1', 'lte:'.(string) $remainingAmount],
        ], [
            'discount.lte' => __('billing.validation-error-message.discount-less-than', ['max' => number_format($remainingAmount, 0)]),

        ])->validate();

        return $input;
    }
}
