<?php

namespace App\Http\Requests\Paket;

use App\Models\Customer\IpStaticPaket;
use Illuminate\Support\Facades\Validator;

class AddPaketStep2Request
{
    /**
     * Validate and create a newly registered customer.
     *
     * @param  array<string, string>  $input
     */
    public function validate(array $input): array
    {
        Validator::make($input, [
            // 'name' => ['required', 'string', 'min:3', 'max:255', 'unique:pakets'],
            //  'unique:pakets,name,null,null,mikrotik_id,' . $input['mikrotik_id'],
            'name' => ['required', 'string', 'min:3', 'max:255', 'unique:pakets,name,null,null,mikrotik_id,' . $input['selectedServer']],
            'price' => ['required', 'numeric'],
            'description' => ['nullable', 'string', 'min:10', 'max:255'],
            'current_password' => ['required', 'string', 'current_password:web'],
        ])->validate();

        return $input;
        // return true;
    }
}
