<?php

namespace App\Jobs\Customers;

use App\Models\Customers\UserBootMessage;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;



class DeleteUserBootMessageJob implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $userBootMessages = UserBootMessage::where('updated_at', '<=', now()->subMinutes(5))->get();
        foreach($userBootMessages as $userBootMessage){
            $userBootMessage->delete();
        }
    }
}
