<?php

namespace App\Jobs\Isolirs;

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use App\Services\CustomerPaketService;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;

class CustomerPaketIsolirJob implements ShouldQueue
{
    use Queueable;

    protected $customerPaket;
    /**
     * Create a new job instance.
     */
    public function __construct($customerPaket)
    {
        $this->customerPaket = $customerPaket;
    }

    /**
     * Execute the job.
     */
    public function handle( CustomerPaketService $customerPaketService): void
    {
        Log::info('Processing auto isolir job...');
        $expiredDate = !is_null($this->customerPaket->paylater_date) ? (Carbon::parse($this->customerPaket->expired_date)->gt(Carbon::parse($this->customerPaket->paylater_date)) ? $this->customerPaket->expired_date : $this->customerPaket->paylater_date) : $this->customerPaket->expired_date;
        if (Carbon::parse($expiredDate)->isPast()) {
            $customerPaketService->set_expired_customer_paket($this->customerPaket);
        }
    }
}
