<?php

namespace App\Jobs\Isolirs;

use Illuminate\Support\Facades\Log;
use App\Models\Customers\CustomerPaket;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;

class CustomerPaketsIsolirJob implements ShouldQueue
{
    use Queueable;

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        CustomerPaket::where('status', 'active')
            ->where('price', '>', 0)
            ->get()
            ->each(function ($customerPaket) {
                $autoIsolir = $customerPaket->paket->mikrotik->auto_isolir;
                if (!$autoIsolir->disabled) {
                    Log::info($customerPaket->user->full_name . ' isolir.');
                    dispatch(new CustomerPaketIsolirJob($customerPaket))->onQueue('default');
                }
            });
    }
}
