<?php

namespace App\Jobs\Notifications;

use DateTime;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use App\Models\Customers\CustomerPaket;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Services\WhatsappGateway\WhatsappNotificationService;

class SendInvoicesReminderJob implements ShouldQueue
{
    use Queueable;
    protected $iUserBill = 0, $userBills = '', $iUserIsolir = 0, $userIsolirs = '';
    /**
     * Execute the job.
     */
    public function handle(WhatsappNotificationService $whatsappNotificationService): void
    {
        CustomerPaket::query()
            ->get()
            ->each(function ($customerPaket) use ($whatsappNotificationService) {
                $invoices = $customerPaket->unpayment_invoices();
                $lastInvoice = $invoices->latest()->first();
                $totalCustomerBill = $whatsappNotificationService->total_bills($customerPaket);
                if ($lastInvoice?->needsReminder()) {
                    Log::info($customerPaket->user->full_name . ' Need reminder: ' . $lastInvoice->needsReminder());
                    $nowDate = new DateTime(Carbon::now()->startOfDay());
                    $deadline = new DateTime($lastInvoice->due_date);
                    $intervalDay = $nowDate->diff($deadline)->format('%a');

                    $customerBillingAddress = $customerPaket->customer_billing_address;
                    $customerBillingPhone = $customerBillingAddress->phone;
                    $isCustomerReceiveNotification = $customerBillingAddress->wa_notification;
                    $isSendReminder = is_null($customerBillingAddress->last_reminder_date) ? true : Carbon::now()->startOfDay()->gt(Carbon::parse($customerBillingAddress->last_reminder_date)->startOfDay());
                    if ($isSendReminder && $isCustomerReceiveNotification && !is_null($customerBillingPhone && $totalCustomerBill > 0)) dispatch(new SendInvoiceReminderJob($customerPaket, $intervalDay))->onQueue('default');

                    $this->iUserBill++;
                    $this->userBills .= $this->iUserBill . '. ' . $customerPaket->user->full_name . ', tagihan: ' . $invoices->count() . ' bulan ( Rp. ' . number_format($totalCustomerBill, 2) . '), Deadline: -' . $intervalDay . ' hari%0a';
                }

                //Send reminder expired to admin
                if ($customerPaket->status === 'expired' && $invoices->count()) {
                    $this->iUserIsolir++;
                    $this->userIsolirs .= $this->iUserIsolir . '. ' . $customerPaket->user->full_name . ', tagihan: ' . $invoices->count() . ' bulan (Rp. ' . number_format($totalCustomerBill, 2) . '), Deadline: ' . Carbon::parse($lastInvoice->due_date)->format('d F Y') . '%0a';
                }
            });

        //send message to admin
        if ($this->iUserBill > 0 || $this->iUserIsolir > 0) {
            $whatsappNotificationService->sendBillsAndIsolirsToAdmin($this->userBills, $this->userIsolirs);
        }
    }
}
