<?php

namespace App\Jobs\Notifications;

use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Services\WhatsappGateway\WhatsappNotificationService;

class SendNotificationPaymentJob implements ShouldQueue
{
    use Queueable;

    protected $payment;
    public function __construct($payment)
    {
        $this->payment = $payment;
    }

    /**
     * Execute the job.
     */
    public function handle(WhatsappNotificationService $whatsappNotificationService): void
    {
        $whatsappNotificationService->sendPaymentNotification($this->payment);
    }
}
