<?php

namespace App\Jobs\Notifications;

use App\Models\Billings\Invoice;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Services\WhatsappGateway\WhatsappNotificationService;

class SendNotificationReadyPaymentJob implements ShouldQueue
{
    use Queueable;

    protected Invoice $invoice;
    public function __construct(Invoice $invoice)
    {
        $this->invoice = $invoice;
    }

    /**
     * Execute the job.
     */
    public function handle(WhatsappNotificationService $whatsappNotificationService): void
    {
        $whatsappNotificationService->sendInvoiceReadyToPaidNotification($this->invoice);
    }
}
