<?php

namespace App\Jobs\Notifications;

use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Services\WhatsappGateway\WhatsappNotificationService;

class SendNotificationRefundPaymentJob implements ShouldQueue
{
    use Queueable;

    protected $payment, $refundedAmount, $method;
    public function __construct($payment, $refundedAmount, $method)
    {
        $this->payment = $payment;
        $this->refundedAmount = $refundedAmount;
        $this->method = $method;
    }

    /**
     * Execute the job.
     */
    public function handle(WhatsappNotificationService $whatsappNotificationService): void
    {
        $whatsappNotificationService->sendRefundPaymentNotification($this->payment, $this->refundedAmount, $this->method);
    }
}
