<?php

namespace App\Livewire\Admin\Billings\Modal;

use App\Models\Bank;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\Billings\Invoice;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use App\Jobs\Payments\PaymentProcessJob;
use Illuminate\Support\Facades\Validator;
use App\Services\Payments\PartialPaymentService;

class BulkPayment extends Component
{
    use NotificationTrait;
    public $bulkPaymentModal = false;
    public $input = [];
    public $invoices;
    #[On('bulk-payment-modal')]
    public function showBulkPaymentModal($invoiceSelected)
    {
        if (Auth::user()->can('invoice payment') || Auth::user()->hasRole('admin')) {
            $this->reset();
            $this->bulkPaymentModal = true;
            $invoices = Invoice::query()
                ->whereIn('id', $invoiceSelected)
                ->get();
            $this->invoices = $invoices;
            $invoiceSelected = [];
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function bulkPayment(PartialPaymentService $partialPaymentService)
    {
        Validator::make($this->input, [
            'selectedPaymentMethode' => ['required'],
            'selectedBankTransfer' => ['required_if:selectedPaymentMethode,==,bank_transfer', 'nullable']

        ], [
            'selectedPaymentMethode.required' => __('billing.validation-error-message.payment-methode-required'),
            'selectedBankTransfer.required_if' => __('billing.validation-error-message.selected-bank-required'),
        ])->validate();

        $bank = null;
        if ($this->input['selectedPaymentMethode'] === 'bank_transfer') {
            $bank = Bank::whereSlug($this->input['selectedBankTransfer'])->first();
            $bank = $bank->bank_name . ' - ' . $bank->account_name . ' - ' . $bank->account_number;
        }

        //$countSuccess = 0;
        //$countFailed = 0;
        $countInvoice = 0;
        foreach ($this->invoices as $invoice) {
            /*
            $response = $partialPaymentService->processPartialPayment(
                $invoice,
                $invoice->amount,
                $this->input['selectedPaymentMethode'],
                $bank
            );
            */
           dispatch(new PaymentProcessJob(
                $invoice,
                $invoice->amount,
                $this->input['selectedPaymentMethode'],
                $bank,
                Auth::user()->full_name
            ))->onQueue('default');
            $countInvoice++;
           // if ($response['success']) {
           //     $countSuccess++;
           // } else {
            //    $countFailed++;
            //    Log::error($response['message']);
            //}
        }

       // $this->dispatch('refresh-billing-paket');
        $this->dispatch('refresh-selected-billing-paket');
        $this->bulkPaymentModal = false;
       // $message = trans('billing.alert.bulk-payment-success-message', ['countSuccess' => $countSuccess, 'countFailed' => $countFailed]);
       // if ($countFailed > 0 && $countSuccess == 0) {
       //     $this->error_notification('Failed', $message);
       // } else {
            $this->success_notification('Success', $countInvoice.' invoices processed in queue job.');
       // }
    }

    public function updatedInputSelectedPaymentMethode($paymentMethode)
    {
        if ($paymentMethode == 'bank_transfer') {
            $this->dispatch('select-methode-transfer', open: true);
        } else {
            $this->dispatch('select-methode-transfer', open: false);
        }
    }

    public function render()
    {
        return view('livewire.admin.billings.modal.bulk-payment');
    }
}
