<?php

namespace App\Livewire\Admin\Billings\Modal;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Services\CustomerPaketService;
use App\Models\Customers\CustomerPaket;
use App\Http\Requests\CurrentPasswordRequest;

class ResetNextBill extends Component
{

    use NotificationTrait;

    public $showResetNextBillModal = false;
    public $input = [];


    #[On('show-reset-next-bill-modal')]
    public function show_reset_next_bill_modal()
    {
        if (Auth::user()->can('configurations management') || Auth::user()->hasRole('admin')) {
            $this->showResetNextBillModal = true;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function reset_next_bill(CurrentPasswordRequest $currentPasswordRequest, CustomerPaketService $customerPaketService)
    {
        $currentPasswordRequest->validate($this->input);
        $customerPakets = CustomerPaket::whereStatus('active')->get();
        foreach ($customerPakets as $customerPaket) {
            $customerPaketService->syncronize_next_billed_at($customerPaket);
        }

        $this->closeModal();
    }

    public function closeModal()
    {
        $this->showResetNextBillModal = false;
        $this->success_notification('Success', 'Reset next bill successfully.');
    }
    public function render()
    {
        return view('livewire.admin.billings.modal.reset-next-bill');
    }
}
