<?php

namespace App\Livewire\Admin\Billings\Payments;

use App\Models\Billings\PaymentHistory;
use Livewire\Component;
use Illuminate\Support\Carbon;

class Teller extends Component
{
    public $year;
    public function mount()
    {
        $this->year = Carbon::now()->format('Y');
    }

    public function render()
    {
        //$users = User::role('admin')->paginate(3);
        
        $paymentHistories = PaymentHistory::whereYear('created_at', $this->year)->get();
        return view('livewire.admin.billings.payments.teller', compact('paymentHistories'));
    }
}
