<?php

namespace App\Livewire\Admin\Billings;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\Billings\Invoice;

class ShowBilling extends Component
{
    public $invoice;
    public function mount($invoice)
    {
        $invoice = Invoice::findOrFail($invoice);
        $this->invoice = $invoice;
    }

     #[On('refresh-payment-list')]
    public function render()
    {
        $payments = $this->invoice->payments()->paginate(10);
        return view('livewire.admin.billings.show-billing', [
            'payments' => $payments
        ]);
    }
}
