<?php

namespace App\Livewire\Admin\Customers;

use App\Models\User;
use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\WithPagination;
use Livewire\Attributes\Title;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\DB;
use App\Models\WhatsappGateway\WhatsappGatewayGeneral;

class CustomersManagement extends Component
{
    use WithPagination, NotificationTrait;
    #[Title('Customers')]
    //Short by
    public $sortField = 'full_name';
    public $sortDirection = 'asc';
    protected $queryString = ['sortField', 'sortDirection'];

    //Search
    public $search_name_or_email = '';
    public $search_with_address = '';
    public $search_phone = '';
    //public $search_gender = '';


    // Pagination
    public $perPageOptions = [5, 10, 25, 50, 100];
    public $perPage = 25;

    //dispatch
    public $alert_title, $alert_message;

    public $first_name, $last_name, $address, $email, $phone;
    public $state = [];

    public $selectedServer;
    public $search_with_paket = '';
    public $search_with_status_customer_paket = '';
    public $search_with_internet_service = '';

    public $usersSelected = [];
    public $selectAll;
    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection == 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection = 'asc';
        }
        $this->sortField = $field;
    }

    public function updatedSearchAddress()
    {
        $this->resetPage();
    }

    public function updatedSearchNameOrEmail()
    {
        $this->resetPage();
    }

    public function updatedSearchGender()
    {
        $this->resetPage();
    }

    /**
     * Alert when user successfully disable or enable
     */
    #[On('user-disable')]
    public function alert($model)
    {
        $model = User::find($model['id']);
        if ($model->disabled) {
            $this->alert_title = trans('user.alert.disable-successfully');
            $this->alert_message = trans('user.alert.user-disable', ['user' => $model->full_name]);
        } else {
            $this->alert_title = trans('user.alert.enable-successfully');
            $this->alert_message = trans('user.alert.user-enable', ['user' => $model->full_name]);
        }
        $this->dispatch('updated');
    }

    /**
     * Export all user
     */
    public function exportUser()
    {
        //  return Excel::download(new UsersExport, 'users.xlsx');
    }

    public function verificationUser(User $user)
    {
        $user->activation();
        $this->success_notification(trans('customer.alert.success'), trans('customer.alert.verification-user-successfully', ['user' => $user->full_name]));
    }

    #[On('notification-user-disable')]
    public function notification($model)
    {
        $this->success_notification(trans('user.alert.user-created'), trans('user.alert.user-created-successfully', ['user' => $model['first_name']]));
    }

    public function bulkDelete()
    {
        //dd($this->usersSelected);
        $this->dispatch('bulk-delete-customer-modal', userSelected: $this->usersSelected);
    }

    public function bulkEdit()
    {
        // dd($this->userActions);
        $this->dispatch('bulk-edit-customer-modal', userSelected: $this->usersSelected);
    }

    #[On('refresh-selected-users')]
    public function refreshSelectedCustomer()
    {
        $this->usersSelected = [];
        $this->selectAll = false;
    }


    private function getCustomers()
    {
        return User::join('user_customers', 'users.id', 'user_customers.user_id')
            ->join('user_addresses', 'users.id', 'user_addresses.user_id')
            ->when($this->search_with_address, function ($builder) {
                $sql = "CONCAT(user_addresses.address, ' ', user_addresses.subdistrict, ' ', user_addresses.district, ' ', user_addresses.city, ' ', user_addresses.province, ' ', user_addresses.country)  like ?";
                $builder->whereRaw($sql,  "%" . $this->search_with_address . "%");
            })
            ->when($this->search_phone, function ($builder) {
                $country_code = WhatsappGatewayGeneral::first()->country_code;
                $builder->where('phone', 'like', '%' . $this->search_phone . '%');
            })

            ->when($this->search_name_or_email, function ($q) {
                $q->where(function ($builder) {
                    $sql = "CONCAT(users.first_name,' ',COALESCE(users.last_name,''))  like ?";
                    $builder->whereRaw($sql,  "%" . $this->search_name_or_email . "%")
                        ->orWhere('email', 'like', '%' . $this->search_name_or_email . '%');
                });
            })
            //->select('user_addresses.id as user_address_id', DB::raw("CONCAT(users.first_name,' ',COALESCE(users.last_name,'')) as full_name"), 'users.*', 'user_addresses.*')
            ->select(
                'user_addresses.id as user_address_id',
                'user_addresses.address as address',
                'user_addresses.phone as phone',
                'user_addresses.wa_notification as wa_notification',
                DB::raw("CONCAT(users.first_name,' ',COALESCE(users.last_name,'')) as full_name"),
                'users.*'
            )
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate($this->perPage);
    }


    #[On('refresh-customer-list')]
    public function render()
    {
        $customers = $this->getCustomers();
        return view('livewire.admin.customers.customers-management', [
            'customers' => $customers
        ]);
    }
}
