<?php

namespace App\Livewire\Admin\Customers\Modal;

use App\Models\User;
use App\Models\Address;
use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Livewire\Actions\Users\UserAddressAction;

class AddAddress extends Component
{
    public $addAddressModal = false;
    public $user;
    public $input = [];
    public $country, $province, $city, $district, $subdistrict;
    public $updateInstallationAddress = false;
    public $updateBillingAddress = false;

    protected $listeners = [
        'countryUpdated' => 'setCountry',
        'provinceUpdated' => 'setProvince',
        'cityUpdated' => 'setCity',
        'districtUpdated' => 'setDistrict',
        'subdistrictUpdated' => 'setSubdistrict',
    ];
    public function setCountry($object)
    {
        $this->country = Address::find($object['value']);
    }

    public function setProvince($object)
    {
        $this->province = Address::find($object['value']);
    }
    public function setCity($object)
    {
        $this->city = Address::find($object['value']);
    }
    public function setDistrict($object)
    {
        $this->district = Address::find($object['value']);
    }
    public function setSubdistrict($object)
    {
        $this->subdistrict = Address::find($object['value']);
    }

    #[On('add-address-modal')]
    public function showAddAddressModal(User $user)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->addAddressModal = true;
            $this->user = $user;
            $userAddress = $user->user_address;

            $this->country = Address::whereName($userAddress->country)->first();
            if ($this->country) {
                request()['country'] = $this->country->id;
                $this->province = Address::whereAddressId($this->country->id)->whereName($userAddress->province)->first();
                if ($this->province) {
                    request()['province'] = $this->province->id;
                    $this->city = Address::whereAddressId($this->province->id)->whereName($userAddress->city)->first();
                    if ($this->city) {
                        request()['city'] = $this->city->id;
                        $this->district = Address::whereAddressId($this->city->id)->whereName($userAddress->district)->first();
                        if ($this->district) {
                            request()['district'] = $this->district->id;
                            $this->subdistrict = Address::whereAddressId($this->district->id)->whereName($userAddress->subdistrict)->first();
                            if ($this->subdistrict) {
                                request()['subdistrict'] = $this->subdistrict->id;
                            }
                        }
                    }
                }
            }
            $this->input['address'] = $userAddress->address;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function closeModal()
    {
        $this->addAddressModal = false;
        $this->dispatch('refresh-customer-list');
    }

    public function addAddress() {}

    public function editAddress()
    {
        $this->input = array_merge($this->input, [
            'country' => $this->country->name ?? '',
            'province' => $this->province->name ?? '',
            'city' => $this->city->name ?? '',
            'district' => $this->district->name ?? '',
            'subdistrict' => $this->subdistrict->name ?? '',
            'phone' => $this->user->user_address->phone ?? null
        ]);

        Validator::make($this->input, [
            'country' => ['required'],
            'province' => ['required'],
            'city' => ['required'],
            'district' => ['required'],
            'subdistrict' => ['required'],
            'address' => ['required', 'min:2'],
        ])->validate();

        (new UserAddressAction())->updateUserAddress($this->user, $this->input, $this->updateInstallationAddress, $this->updateBillingAddress);
        $this->closeModal();
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.add-address');
    }
}
