<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use App\Models\Bank;
use Livewire\Component;
use Carbon\CarbonPeriod;
use Livewire\Attributes\On;
use App\Traits\WebSystemTrait;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Services\CustomerPaketService;
use App\Models\Customers\CustomerPaket;
use Illuminate\Support\Facades\Validator;
use App\Services\Payments\PartialPaymentService;
use App\Traits\NotificationTrait;

class ActivationPaket extends Component
{
    use WebSystemTrait, NotificationTrait;
    public $activationCustomerPaketModal = false;
    public $customerPaket;
    public $input = [];
    public $invoice, $isPrabayar, $dates;

    #[On('activation-customer-paket-modal')]
    public function showActivationCustomerPaketModal(CustomerPaket $customerPaket)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->invoice = $customerPaket->invoices()->where('status','!=', 'paid')->first();
            $this->resetErrorBag();
            $this->activationCustomerPaketModal = true;
            $this->customerPaket = $customerPaket;
            $this->input['markAsPayment'] = false;
            $this->input['selectedPaymentMethode'] = '';
            $this->input['selectedBankTransfer'] = '';
            $this->isPrabayar = $this->isPrabayar();

            if ($customerPaket->mikrotik->auto_isolir->activation_date) {
                if ($this->isPrabayar) {
                    $this->input['startPaymentDate'] = Carbon::now()->addDays($customerPaket->paket->trial_days)->format('Y-m-d');
                } else {
                    $this->input['startPaymentDate'] = Carbon::now()->add($customerPaket->getRenewalPeriod())->addDays($customerPaket->paket->trial_days)->format('Y-m-d');
                }
            } else {
                $nowPaymentDate = Carbon::now()->setDay((int)$customerPaket->mikrotik->auto_isolir->due_date);
                if ($nowPaymentDate->lt(\Carbon\Carbon::now())) {
                    $this->dates = CarbonPeriod::create(now()->addMonth()->setDay((int)$customerPaket->mikrotik->auto_isolir->due_date), '1 month', now()->addMonth()->setDay((int)$customerPaket->mikrotik->auto_isolir->due_date)->add($customerPaket->getRenewalPeriod()))->toArray();
                } else {
                    $this->dates = CarbonPeriod::create(now()->setDay((int)$customerPaket->mikrotik->auto_isolir->due_date), '1 month', now()->setDay((int)$customerPaket->mikrotik->auto_isolir->due_date)->add($customerPaket->getRenewalPeriod()))->toArray();
                }
                $this->input['startPaymentDate'] = Carbon::parse(collect($this->dates)->first())->format('Y-m-d');
            }
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function updatedInputSelectedPaymentMethode($paymentMethode)
    {
        $paymentMethode ? $this->dispatch('input-amount', open: true) : $this->dispatch('input-amount', open: false);
        if ($paymentMethode === 'bank_transfer') {
            $this->dispatch('select-methode-transfer', open: true);
        } else {
            $this->dispatch('select-methode-transfer', open: false);
        }
    }

    public function activation_paket(CustomerPaketService $customerPaketService, PartialPaymentService $partialPaymentService)
    {
        if ($this->input['markAsPayment'] && $this->customerPaket->status === 'pending' && $this->invoice) {
            Validator::make($this->input, [
                'selectedPaymentMethode' => ['required'],
                'paylaterDate' => ['required_if:selectedPaymentMethode,==,paylater', 'nullable'],
                'selectedBankTransfer' => ['required_if:selectedPaymentMethode,==,bank_transfer', 'nullable'],
                'current_password' => ['required', 'string', 'current_password:web'],
                'startPaymentDate' => ['required']
            ], [
                'selectedPaymentMethode.required' => __('billing.validation-error-message.payment-methode-required'),
                'selectedBankTransfer.required_if' => __('billing.validation-error-message.selected-bank-required'),
            ])->validate();
        } else {
            Validator::make($this->input, [
                'current_password' => ['required', 'string', 'current_password:web'],
                'startPaymentDate' => ['required']
            ], [
                'current_password.required' => __('customer.validation-error-message.current-password-required'),
            ])->validate();
        }

        DB::beginTransaction();
        try {
            //Activation paket
            $activation = $customerPaketService->activationCustomerPaket($this->customerPaket, $this->input['startPaymentDate']);

            if ($activation['success']) {
                if ($this->isPrabayar && $this->invoice) {
                    if ($this->input['startPaymentDate'] != $this->invoice->start_periode) {
                        $startPeriod = Carbon::parse($this->input['startPaymentDate']);
                        $endPeriod = Carbon::parse($startPeriod)->add($this->customerPaket->getRenewalPeriod());
                        $this->invoice->forceFill([
                            'start_periode' => $startPeriod,
                            'end_periode' => $endPeriod
                        ])->save();

                        //$this->customerPaket->forceFill([
                        //    'next_billed_at' => $endPeriod->subDays($this->different_day_create_billing())
                        //])->save();
                    }

                    //Mark as payment invoice
                    if ($this->input['markAsPayment']) {
                        $bank = null;
                        $amount = $this->invoice->total_amount;
                        if ($this->input['selectedPaymentMethode'] === 'bank_transfer') {
                            $bank = Bank::whereSlug($this->input['selectedBankTransfer'])->first();
                            $bank = $bank->bank_name . ' - ' . $bank->account_name . ' - ' . $bank->account_number;
                        }

                        //Update start and end period invoice

                        $partialPaymentService->processPartialPayment(
                            $this->invoice,
                            $amount,
                            $this->input['selectedPaymentMethode'],
                            $bank,
                            Auth::user()->full_name
                        );
                    }
                }
                DB::commit();
                $this->success_notification('Success', $activation['message']);
                $this->closeModal();
            } else {
                DB::rollBack();
                $this->error_notification('Failed!', $activation['message']);
            }
        } catch (\Exception $e) {
            DB::rollBack();
            $this->error_notification('Failed!', $e->getMessage());
        }
    }

    public function closeModal()
    {
        $this->dispatch('refresh-customer-list');
        $this->activationCustomerPaketModal = false;
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.activation-paket');
    }
}
