<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use App\Models\User;
use App\Models\Address;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\Pakets\Paket;
use App\Models\Pakets\PppType;
use App\Models\Servers\Mikrotik;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use App\Models\Pakets\InternetService;
use App\Services\CustomerPaketService;
use App\Services\Mikrotiks\MikrotikService;
use App\Http\Requests\Customers\AddCustomerPaketRequest;
use App\Http\Requests\Customers\AddAddressCustomerPaketRequest;

class AddCustomerPaketModal extends Component
{
    use NotificationTrait;
    public $addCustomerPaketModal = false;
    public $input = [];
    public $user;
    public $currentStep = 1;

    public $address = false;
    public $checkbox_installation_address = false;
    public $checkbox_billing_address = false;

    public $internet_services, $ppp_services, $mikrotik_interfaces;
    public $selectedServer = null, $selectedPaket = null, $selectedPppService = null, $selectedMikrotikInterface = null, $selectedInternetService = null;


    #[On('add-customer-paket-modal')]
    public function showAddCustomerPaketModal(User $user)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->resetErrorBag();
            $this->addCustomerPaketModal = true;
            $this->user = $user;
            $this->internet_services = collect();
            $this->ppp_services = collect();
            $this->mikrotik_interfaces = collect();
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    protected $listeners = [
        'countryUpdated' => 'setCountry',
        'provinceUpdated' => 'setProvince',
        'cityUpdated' => 'setCity',
        'districtUpdated' => 'setDistrict',
        'subdistrictUpdated' => 'setSubdistrict',
    ];

    public function setCountry($object)
    {
        $this->input['country'] = Address::find($object['value']);
    }
    public function setProvince($object)
    {
        $this->input['province'] = Address::find($object['value']);
    }
    public function setCity($object)
    {
        $this->input['city'] = Address::find($object['value']);
    }
    public function setDistrict($object)
    {
        $this->input['district'] = Address::find($object['value']);
    }
    public function setSubdistrict($object)
    {
        $this->input['subdistrict'] = Address::find($object['value']);
    }

    public function addressInstallation(AddCustomerPaketRequest $request)
    {
        $this->resetErrorBag();
        $this->input['selectedServer'] = $this->selectedServer;
        $request->validate(
            $this->input
        );
        $this->updateInputAddressWithLastValue();
        $this->currentStep = 2;
    }

    public function addressBilling(AddAddressCustomerPaketRequest $addressRequest)
    {
        $this->resetErrorBag();
        if ($this->checkbox_installation_address) {
            $addressRequest->validate(
                $this->input
            );
            $this->updateInputAddressWithLastValue();
            $this->input['installation_country'] = $this->input['country']->name ?? null;
            $this->input['installation_province'] = $this->input['province']->name ?? null;
            $this->input['installation_city'] = $this->input['city']->name ?? null;
            $this->input['installation_district'] = $this->input['district']->name ?? null;
            $this->input['installation_subdistrict'] = $this->input['subdistrict']->name ?? null;
            $this->input['installation_address'] = $this->input['address'] ?? null;
            $this->input['installation_phone'] = $this->input['phone'] ?? null;
        } else {
            $this->input['installation_country'] = $this->user->user_address->country;
            $this->input['installation_province'] = $this->user->user_address->province;
            $this->input['installation_city'] = $this->user->user_address->city;
            $this->input['installation_district'] = $this->user->user_address->district;
            $this->input['installation_subdistrict'] = $this->user->user_address->subdistrict;
            $this->input['installation_address'] = $this->user->user_address->address;
            $this->input['installation_phone'] = $this->user->user_address->phone;
        }
        $this->currentStep = 3;
    }

    public function addCustomerPaket(AddAddressCustomerPaketRequest $addressRequest, CustomerPaketService $customerPaketService)
    {
        $this->resetErrorBag();

        if ($this->checkbox_billing_address) {
            $addressRequest->validate(
                $this->input
            );
            $this->input['billing_country'] = $this->input['country']->name ?? null;
            $this->input['billing_province'] = $this->input['province']->name ?? null;
            $this->input['billing_city'] = $this->input['city']->name ?? null;
            $this->input['billing_district'] = $this->input['district']->name ?? null;
            $this->input['billing_subdistrict'] = $this->input['subdistrict']->name ?? null;
            $this->input['billing_address'] = $this->input['address']->name ?? null;
            $this->input['billing_phone'] = $this->input['phone']->name ?? null;
        } else {
            $this->input['billing_country'] = $this->user->user_address->country;
            $this->input['billing_province'] = $this->user->user_address->province;
            $this->input['billing_city'] = $this->user->user_address->city;
            $this->input['billing_district'] = $this->user->user_address->district;
            $this->input['billing_subdistrict'] = $this->user->user_address->subdistrict;
            $this->input['billing_address'] = $this->user->user_address->address;
            $this->input['billing_phone'] = $this->user->user_address->phone;
        }
        DB::beginTransaction();
        try {
            $customerPaket = $customerPaketService->addCustomerPaket($this->user, $this->input);
            DB::commit();

            $this->dispatch('refresh-customer-list');
            $this->closeAddCustomerPaketModal();
            $this->success_notification(trans('customer.paket.alert.success'), trans('customer.paket.alert.add-customer-paket-successfully', ['customer' => $this->user->full_name, 'paket' => $customerPaket->paket->name]));
            //$this->reset();
            return $this->redirect(route('customer.show', $this->user->username), navigate: true);
        } catch (\Exception $e) {
            DB::rollBack();
            $this->error_notification(trans('customer.paket.alert.failed'), $e->getMessage());
        }
    }

    public function closeAddCustomerPaketModal()
    {
        $this->addCustomerPaketModal = false;
    }

    public function back($step)
    {
        $this->currentStep = $step;
    }

    public function updatedCheckboxBillingAddress($enable)
    {
        if ($enable) {
            $this->updateInputAddressWithLastValue();
        }
    }

    public function updatedCheckboxInstallationAddress($enable)
    {
        if ($enable) {
            $this->updateInputAddressWithLastValue();
        }
    }

    private function updateInputAddressWithLastValue()
    {
        request()['country'] = $this->input['country']->id ?? null;
        request()['province'] = $this->input['province']->id ?? null;
        request()['city'] = $this->input['city']->id ?? null;
        request()['district'] = $this->input['district']->id ?? null;
        request()['subdistrict'] = $this->input['subdistrict']->id ?? null;
    }
    /**
     * Update dropdown
     */
    public function updatedSelectedServer($server)
    {
        $this->resetErrorBag();
        $this->input['selectedPaket'] = '';
        $this->input['selectedInternetService'] = '';
        $this->input['selectedPppService'] = '';
        $this->selectedInternetService = null;
        $this->selectedPaket = null;
    }

    public function updatedInputSelectedPaket($paket)
    {
        if (!is_null($paket)) {
            $this->resetErrorBag('selectedPaket');
            $this->selectedPaket = Paket::where('id', $paket)->first();
            $this->internet_services = InternetService::all();
        }
    }

    public function updatedInputSelectedInternetService($internet_service_value)
    {
        $this->input['ip_address'] = '';
        $this->resetErrorBag();
        if ($internet_service_value) {
            $this->resetErrorBag('selectedInternetService');
            $this->selectedInternetService = $internet_service_value;
            if ($this->selectedInternetService == 'ppp') {
                $this->ppp_services = PppType::all();
            } else if ($this->selectedInternetService == 'ip_static') {
                //get interface mikrotik
                $mikrotik = Mikrotik::where('id', $this->selectedServer)->first();
                try {
                    $this->mikrotik_interfaces = (new MikrotikService())->mikrotikEtherInterface($mikrotik);
                } catch (\Exception $e) {
                    $this->mikrotik_interfaces = null;
                }
            }
        } else {
            $this->selectedInternetService = '';
        }
    }

    public function updatedInputSelectedPppService($pppService)
    {
        if (!is_null($pppService)) {
            $this->resetErrorBag('selectedPppService');
        }
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.add-customer-paket-modal');
    }
}
