<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\WebSystemTrait;
use Illuminate\Support\Carbon;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Services\CustomerPaketService;
use App\Models\Customers\CustomerPaket;

class BulkEditActivation extends Component
{
    use NotificationTrait, WebSystemTrait;
    public $bulkEditActivationModal = false;
    public $customerPakets;
    public $input = [];
    public $expiredDate, $nextBilledAt;

    #[On('bulk-edit-activation-paket-modal')]
    public function showBulkEditActivationModal($customerPaketSelected)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->reset();
            $this->bulkEditActivationModal = true;
            $customerPakets = CustomerPaket::query()
                ->whereIn('id', $customerPaketSelected)
                ->get();
            $this->customerPakets = $customerPakets;
            $customerPaketSelected = [];
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function edit_bulk_activation_paket(CustomerPaketService $customerPaketService)
    {
        $this->input['start_date'] = $this->input['start_date'] ?? null;
        foreach ($this->customerPakets as $customerPaket) {
            // dd($customerPaket->mikrotik->auto_isolir->due_date);
            $expiredDate = $this->input['start_date'] ? Carbon::parse($this->input['start_date'])->add($customerPaket->getRenewalPeriod()) : null;
            $nextBilledAt = $this->input['start_date'] ? Carbon::parse($expiredDate)->subDays((int)$this->different_day_create_billing()) : null;

            DB::beginTransaction();
            try {
                $customerPaketService->editActivationDate(
                    $customerPaket,
                    $this->input['activation_date'] ?? null,
                    $this->input['start_date'],
                    $expiredDate,
                    $nextBilledAt
                );
                DB::commit();
                $this->dispatch('refresh-customer-paket-list');
                $this->dispatch('refresh-selected-customer-pakets');
                $this->success_notification('Success', trans('customer.paket.alert.edit-activation-paket-succesfully'));
            } catch (\Exception $e) {
                DB::rollBack();
                $this->error_notification('Failed', $e->getMessage());
            }
        }
        $this->bulkEditActivationModal = false;
        if ($this->customerPakets->count() <= 0) {
            $this->error_notification('Failed', 'No changes');
        }
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.bulk-edit-activation');
    }
}
