<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\DB;
use App\Services\GeneralLogServices;
use Illuminate\Support\Facades\Auth;
use App\Models\Customers\CustomerPaket;
use App\Http\Requests\CurrentPasswordRequest;
use App\Services\CustomerPaketService;

class DeleteCustomerPaketPermanently extends Component
{
    use NotificationTrait;

    public $deletePermanentlyCustomerPaketModal = false;
    public $customerPaket;
    public $input = [];



    #[On('delete-permanently-customer-paket-modal')]
    public function showDeleteCustomerModal($customerPaketId)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->customerPaket = CustomerPaket::withTrashed()->findOrFail($customerPaketId);
            $this->deletePermanentlyCustomerPaketModal = true;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function deletePermanentlyCustomerPaket(CurrentPasswordRequest $request, GeneralLogServices $generalLogServices, CustomerPaketService $customerPaketService)
    {
        $this->resetErrorBag();
        $request->validate($this->input);

        DB::beginTransaction();
        try {
            $paketName = $this->customerPaket->paket->name;
            $paketServer = $this->customerPaket->paket->mikrotik->name;
            $customerName = $this->customerPaket->user->full_name;
            $message = "Delete permanently paket " . $paketName . '-' . $paketServer . ' on ' . $customerName;



            $this->customerPaket->forceDelete();
            $generalLogServices->admin_action($generalLogServices::DELETE_CUSTOMER_PAKET, $message, Auth::user()->full_name);
            DB::commit();
            $this->success_notification(trans('customer.alert.success'), $message);
        } catch (\Exception $e) {
            DB::rollBack();
            $this->error_notification(trans('customer.alert.failed'), $e->getMessage());
        }
        $this->closeModal();
    }

    public function closeModal()
    {
        $this->deletePermanentlyCustomerPaketModal = false;
        $this->dispatch('refresh-deleted-customer-paket-list');
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.delete-customer-paket-permanently');
    }
}
