<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Services\CustomerPaketService;
use App\Models\Customers\CustomerPaket;
use App\Http\Requests\CurrentPasswordRequest;

class DisableCustomerPaket extends Component
{
    use NotificationTrait;
    public $disableCustomerPaketModal = false;
    public $customerPaket;

    public $input = [];
    public $button;
    public $customerPaketStatuses;

    private CustomerPaketService $customerPaketService;
    public function boot(CustomerPaketService $customerPaketService)
    {
        $this->customerPaketService = $customerPaketService;
    }

    #[On('disable-customer-paket-modal')]
    public function showAddCustomerPaketModal(CustomerPaket $customerPaket)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->resetErrorBag();
            $this->disableCustomerPaketModal = true;
            $this->customerPaket = $customerPaket;
            $customerPaketStatuses = collect([
                ['value' => 'active', 'title' => 'customer.status.active'],
                ['value' => 'expired', 'title' => 'customer.status.expired'],
                ['value' => 'suspended', 'title' => 'customer.status.suspend'],
                ['value' => 'cancelled', 'title' => 'customer.status.cancel'],
            ]);

            $this->customerPaketStatuses = $customerPaketStatuses->where('value', '!=', $customerPaket->status);
            $status = $this->customerPaketStatuses->first();
            $this->input['status'] = $this->button = $status['value'];
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function update_status_paket(CurrentPasswordRequest $currentPasswordRequest)
    {
        $currentPasswordRequest->validate($this->input);
        DB::beginTransaction();
        $this->customerPaketService->updateStatusCustomerPaket($this->customerPaket, $this->input['status']);
        DB::commit();

        //if ($updateStatusPaket['success']) {
        $title =  trans('customer.paket.alert.' . $this->customerPaket->status);
        $message = trans('customer.paket.alert.detail-customer-paket-' . $this->customerPaket->status, ['customer' => $this->customerPaket->user->full_name, 'paket' => $this->customerPaket->paket->name]);
        $this->success_notification($title, $message);
        $this->closeModal();
        //} else {
        //    $this->error_notification('Failed!', $updateStatusPaket['message']);
        //}
    }

    public function closeModal()
    {
        $this->disableCustomerPaketModal = false;
        $this->dispatch('refresh-customer-list');
        $this->reset();
    }

    public function updatedInputStatus($value)
    {
        $this->button = $value;
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.disable-customer-paket');
    }
}
