<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Validation\Rule;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\DB;
use App\Traits\StandardPhoneNumber;
use Illuminate\Support\Facades\Auth;
use App\Services\CustomerPaketService;
use App\Models\Customers\CustomerPaket;
use Illuminate\Support\Facades\Validator;

class DisableWaNotificationInstallationAddress extends Component
{
    use StandardPhoneNumber, NotificationTrait;

    public $disableWaInstallationAddressModal = false;
    public $customerPaket;
    public $input = [];

    private CustomerPaketService $customerPaketService;
    public function boot(CustomerPaketService $customerPaketService)
    {
        $this->customerPaketService = $customerPaketService;
    }

    #[On('disable-wa-notification-installation-address-modal')]
    public function showDisableWaNotification(CustomerPaket $customerPaket)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->resetErrorBag();
            $this->disableWaInstallationAddressModal = true;
            $this->customerPaket = $customerPaket;
            $this->input = array_merge([
                'checkbox_wa_installation_address_notification' => $customerPaket->customer_installation_address->wa_notification ? true : false,
                'checkbox_wa_billing_address_notification' => $customerPaket->customer_billing_address->wa_notification ? true : false,
                'billing_phone' => $this->localPhoneNumberFormat($customerPaket->customer_billing_address->phone),
                'installation_phone' => $this->localPhoneNumberFormat($customerPaket->customer_installation_address->phone),
            ]);
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function disable_wa_notification_installation_address()
    {
        Validator::make($this->input, [
            'current_password' => ['required', 'string', 'current_password:web'],
            'installation_phone' => [Rule::requiredIf($this->input['checkbox_wa_installation_address_notification']), 'nullable', 'numeric'],
            'billing_phone' => [Rule::requiredIf($this->input['checkbox_wa_billing_address_notification']), 'nullable', 'numeric'],
        ], [
            'current_password.required' => __('customer.validation-error-message.current-password-required'),
        ])->validate();

        DB::beginTransaction();
        $disabled = $this->customerPaketService->disableWaNotificationCustomerPaketAddress($this->customerPaket, $this->input);
        DB::commit();

        if ($disabled['success']) {
            $this->success_notification('Success', $disabled['message']);
            $this->closeModal();
        } else {
            $this->error_notification('Failed!', $disabled['message']);
        }
    }

    public function closeModal()
    {
        $this->disableWaInstallationAddressModal = true;
        $this->dispatch('refresh-customer-list');
        $this->reset();
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.disable-wa-notification-installation-address');
    }
}
