<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use Livewire\Component;
use Carbon\CarbonPeriod;
use Livewire\Attributes\On;
use App\Traits\WebSystemTrait;
use Illuminate\Support\Carbon;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Services\CustomerPaketService;
use App\Models\Customers\CustomerPaket;

class EditActivation extends Component
{
    use NotificationTrait, WebSystemTrait;
    public $editActivationCustomerPaketModal = false;
    public $customerPaket, $dates, $expiredDate, $nextBilledAt;
    public $input = [];

    #[On('edit-activation-customer-paket-modal')]
    public function showEditActivationCustomerPaketModal(CustomerPaket $customerPaket)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->resetErrorBag();
            $this->editActivationCustomerPaketModal = true;
            $this->customerPaket = $customerPaket;
            $this->input['activation_date'] = Carbon::parse($customerPaket->activation_date)->format('Y-m-d');
            $this->input['selectStartDate'] = Carbon::parse($customerPaket->start_date)->format('Y-m-d');
            $this->expiredDate = Carbon::parse($this->input['selectStartDate'])->add($this->customerPaket->getRenewalPeriod());
            $this->nextBilledAt = Carbon::parse($this->expiredDate)->subDays((int)$this->different_day_create_billing());

            $activationDay = Carbon::parse($this->customerPaket->activation_date)->format('d');
            if ($this->isPrabayar()) {
                $this->dates = CarbonPeriod::create(now()->subMonth()->setDay((int)$activationDay), '1 month', now()->addMonth()->setDay((int)$activationDay))->toArray();
            } else {
                $this->dates = CarbonPeriod::create(now()->setDay((int)$activationDay), '1 month', now()->addMonth()->setDay((int)$activationDay))->toArray();
            }
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function updatedInputActivationDate($value)
    {
        $activationDay = (int)Carbon::parse($value)->format('d');
        if ($this->isPrabayar()) {
            $this->dates = CarbonPeriod::create(now()->subMonth()->setDay($activationDay), '1 month', now()->addMonth()->setDay($activationDay))->toArray();
        } else {
            $this->dates = CarbonPeriod::create(now()->setDay($activationDay), '1 month', now()->addMonth()->setDay($activationDay))->toArray();
        }
        $this->input['selectStartDate'] = Carbon::parse($this->customerPaket->start_date)->setDay((int)$activationDay)->format('Y-m-d');

        $this->expiredDate = Carbon::parse($this->input['selectStartDate'])->add($this->customerPaket->getRenewalPeriod());
        $this->nextBilledAt = Carbon::parse($this->expiredDate)->subDays((int)$this->different_day_create_billing());
    }

    public function updatedInputSelectStartDate($value)
    {
        $this->expiredDate = Carbon::parse($value)->add($this->customerPaket->getRenewalPeriod());
        $this->nextBilledAt = Carbon::parse($this->expiredDate)->subDays((int)$this->different_day_create_billing());
    }
    public function edit_activation_paket(CustomerPaketService $customerPaketService)
    {
        DB::beginTransaction();
        try {
            $customerPaketService->editActivationDate(
                $this->customerPaket,
                $this->input['activation_date'],
                $this->input['selectStartDate'],
                $this->expiredDate,
                $this->nextBilledAt
            );

            $this->dispatch('refresh-customer-paket-list');
            $this->editActivationCustomerPaketModal = false;
            $this->success_notification('Success', trans('customer.paket.alert.edit-activation-paket-succesfully'));
            DB::commit();
        } catch (\Exception $e) {
            $this->error_notification('Failed', $e->getMessage());
            DB::rollBack();
        }
    }
    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.edit-activation');
    }
}
