<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use App\Models\Address;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use App\Models\Customers\CustomerPaket;
use Jantinnerezo\LivewireAlert\Facades\LivewireAlert;
use App\Livewire\Actions\Customers\CustomerPaketAddressAction;
use App\Http\Requests\Customers\AddAddressCustomerPaketRequest;
use App\Http\Requests\Customers\UpdateAddressCustomerPaketRequest;


class EditCustomerPaketAddressModal extends Component
{
    use NotificationTrait;

    public $editCustomerPaketAddressModal = false;
    public $input = [];
    public $customerPaket;
    public $currentStep = 1;
    public $country, $province, $city, $district, $subdistrict;


    #[On('edit-customer-paket-address-modal')]
    public function showEditCustomerPaketModal(CustomerPaket $customerPaket)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->resetErrorBag();
            $this->editCustomerPaketAddressModal = true;
            $this->customerPaket = $customerPaket;

            $installationAddress = $this->customerPaket->customer_installation_address;
            $this->getCustomerPaketAddress($installationAddress);

            $this->currentStep = 1;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    protected $listeners = [
        'countryUpdated' => 'setCountry',
        'provinceUpdated' => 'setProvince',
        'cityUpdated' => 'setCity',
        'districtUpdated' => 'setDistrict',
        'subdistrictUpdated' => 'setSubdistrict',
    ];
    public function setCountry($object)
    {
        $this->country = Address::find($object['value']);
        $this->province = null;
        $this->city = null;
        $this->district = null;
        $this->subdistrict = null;
    }

    public function setProvince($object)
    {
        $this->province = Address::find($object['value']);
    }

    public function setCity($object)
    {
        $this->city = Address::find($object['value']);
    }

    public function setDistrict($object)
    {
        $this->district = Address::find($object['value']);
    }
    public function setSubdistrict($object)
    {
        $this->subdistrict = Address::find($object['value']);
    }

    private function getCustomerPaketAddress($typeAddress)
    {
        if ($typeAddress) {
            $this->country = Address::whereName($typeAddress->country)->first();
            if ($this->country) {
                request()['country'] = $this->country->id;
                $this->province = Address::whereAddressId($this->country->id)->whereName($typeAddress->province)->first();
                if ($this->province) {
                    request()['province'] = $this->province->id;
                    $this->city = Address::whereAddressId($this->province->id)->whereName($typeAddress->city)->first();
                    if ($this->city) {
                        request()['city'] = $this->city->id;
                        $this->district = Address::whereAddressId($this->city->id)->whereName($typeAddress->district)->first();
                        if ($this->district) {
                            request()['district'] = $this->district->id;
                            $this->subdistrict = Address::whereAddressId($this->district->id)->whereName($typeAddress->subdistrict)->first();
                            if ($this->subdistrict) {
                                request()['subdistrict'] = $this->subdistrict->id;
                            }
                        }
                    }
                }
            }
            $this->input['address'] = $typeAddress->address;
            $this->input['phone'] = $typeAddress->phone;
        }
    }

    public function updateInstallationAddress(UpdateAddressCustomerPaketRequest $updateAddressRequest)
    {
        $this->input = array_merge($this->input, [
            'country' => $this->country->name ?? '',
            'province' => $this->province->name ?? '',
            'city' => $this->city->name ?? '',
            'district' => $this->district->name ?? '',
            'subdistrict' => $this->subdistrict->name ?? ''
        ]);

        $updateAddressRequest->validate(
            $this->customerPaket,
            $this->input
        );
        $this->input['installation_country'] = $this->input['country'];
        $this->input['installation_province'] = $this->input['province'];
        $this->input['installation_city'] = $this->input['city'];
        $this->input['installation_district'] = $this->input['district'];
        $this->input['installation_subdistrict'] = $this->input['subdistrict'];
        $this->input['installation_address'] = $this->input['address'];
        $this->input['installation_phone'] = $this->input['phone'];

        /*
        if ($this->customerPaket->customer_installation_address->country) {
            $this->updatedInputCountry($this->input['country'] = $this->customerPaket->customer_billing_address->country);
            $this->updatedInputProvince($this->input['province'] = $this->customerPaket->customer_billing_address->province);
            $this->updatedInputCity($this->input['city'] = $this->customerPaket->customer_billing_address->city);
            $this->updatedInputDistrict($this->input['district'] = $this->customerPaket->customer_billing_address->district);
            $this->input['subdistrict'] = $this->customerPaket->customer_billing_address->subdistrict;
            $this->input['address'] = $this->customerPaket->customer_billing_address->address;
            $this->input['phone'] = $this->customerPaket->customer_billing_address->phone;
        } else {
            $this->updatedInputCountry($this->input['country'] = $this->customerPaket->user->user_address->country);
            if ($this->customerPaket->user->user_address->province)
                $this->updatedInputProvince($this->input['province'] = $this->customerPaket->user->user_address->province);
            if ($this->customerPaket->user->user_address->city)
                $this->updatedInputCity($this->input['city'] = $this->customerPaket->user->user_address->city);
            if ($this->customerPaket->user->user_address->district)
                $this->updatedInputDistrict($this->input['district'] = $this->customerPaket->user->user_address->district);
            if ($this->customerPaket->user->user_address->subdistrict)
                $this->input['subdistrict'] = $this->customerPaket->user->user_address->subdistrict;
            $this->input['address'] = $this->customerPaket->user->user_address->address;
            $this->input['phone'] = $this->customerPaket->user->user_address->phone;
        }
            */

        $this->currentStep = 2;
        $billingAddress = $this->customerPaket->customer_billing_address;
        $this->getCustomerPaketAddress($billingAddress);
    }

    public function updateCustomerPaketAddress(UpdateAddressCustomerPaketRequest $updateAddressRequest)
    {
        $this->input = array_merge($this->input, [
            'country' => $this->country->name ?? '',
            'province' => $this->province->name ?? '',
            'city' => $this->city->name ?? '',
            'district' => $this->district->name ?? '',
            'subdistrict' => $this->subdistrict->name ?? ''
        ]);
        $updateAddressRequest->validate(
            $this->customerPaket,
            $this->input
        );
        $this->input['billing_country'] = $this->input['country'];
        $this->input['billing_province'] = $this->input['province'];
        $this->input['billing_city'] = $this->input['city'];
        $this->input['billing_district'] = $this->input['district'];
        $this->input['billing_subdistrict'] = $this->input['subdistrict'];
        $this->input['billing_address'] = $this->input['address'];
        $this->input['billing_phone'] = $this->input['phone'];

        DB::beginTransaction();
        try {
            (new CustomerPaketAddressAction())->updateInstallationAddress($this->customerPaket->customer_installation_address, $this->input);
            (new CustomerPaketAddressAction())->updateBillingAddress($this->customerPaket->customer_billing_address, $this->input);
            DB::commit();
            $this->closeModal();
            LivewireAlert::title(trans('customer.alert.success'))
                ->text(trans('customer.alert.message-update-success'))
                ->position('top-end')
                ->toast()
                ->status('success')
                ->show();
        } catch (\Exception $e) {
            DB::rollBack();
            LivewireAlert::title(trans('customer.alert.failed'))
                ->text($e->getMessage())
                ->position('top-end')
                ->toast()
                ->status('error')
                ->show();
        }
    }

    public function closeModal()
    {
        $this->editCustomerPaketAddressModal = false;
        $this->dispatch('refresh-customer-paket-list');
        $this->reset();
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.edit-customer-paket-address-modal');
    }
}
