<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Models\Customers\CustomerPaket;
use Illuminate\Support\Facades\Validator;
use Jantinnerezo\LivewireAlert\Facades\LivewireAlert;

class EditMacAddress extends Component
{
    use NotificationTrait;
    public $editMacAddressModal = false;
    public $customerPaket;
    public $input = [];

    #[On('edit-mac-address-modal')]
    public function showEditMAcAddressModal(CustomerPaket $customerPaket)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->resetErrorBag();
            $this->editMacAddressModal = true;
            $this->customerPaket = $customerPaket;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function edit_mac_address()
    {
        Validator::make($this->input, [
            'mac_address' => ['required', 'mac_address'],
        ])->validate();
        $this->customerPaket->customer_static_paket->forceFill([
            'mac_address' => $this->input['mac_address']
        ])->save();
        $this->success_notification('Success', 'Update MAC address successfully.');
        $this->closeModal();
    }

    public function closeModal()
    {
        $this->editMacAddressModal = false;
        $this->dispatch('refresh-customer-list');
        $this->reset();
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.edit-mac-address');
    }
}
