<?php

namespace App\Livewire\Admin\Customers\Modal\CustomerPaket;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\DB;
use App\Services\GeneralLogServices;
use Illuminate\Support\Facades\Auth;
use App\Services\CustomerPaketService;
use App\Models\Customers\CustomerPaket;

class RestoreCustomerPaket extends Component
{
    use NotificationTrait;
    public $restoreCustomerPaketModal = false;
    public $customerPaket;
    public $input = [];

    #[On('restore-customer-paket-modal')]
    public function showRestoreCustomerPaketModal($customerPaketId)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->reset();
            $this->input['restoreOnMikrotik'] = true;
            $this->customerPaket = CustomerPaket::withTrashed()->findOrFail($customerPaketId);

            $this->restoreCustomerPaketModal = true;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function restoredCustomerPaket(CustomerPaketService $customerPaketService, GeneralLogServices $generalLogServices)
    {
        DB::beginTransaction();
        try {
            $customerPaketService->restore_deleted_customer_paket($this->customerPaket, $this->input['restoreOnMikrotik']);
            DB::commit();

            $this->success_notification('Restore Success', 'Restore customer paket successfully');
            $this->dispatch('refresh-deleted-customer-paket-list');
        } catch (\Exception $e) {
            DB::rollBack();
            $this->error_notification('Restore Failed!', $e->getMessage());
        }
        $this->restoreCustomerPaketModal = false;
    }


    public function render()
    {
        return view('livewire.admin.customers.modal.customer-paket.restore-customer-paket');
    }
}
