<?php

namespace App\Livewire\Admin\Customers\Modal;

use App\Models\User;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Services\CustomerService;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\CurrentPasswordRequest;

class DeleteCustomer extends Component
{
    use NotificationTrait;

    public $deleteCustomerModal = false;
    public $user;
    public $input = [];

    #[On('delete-customer-modal')]
    public function showDeleteCustomerModal(User $user)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->deleteCustomerModal = true;
            $this->user = $user;
            $this->input['deleteOnMikrotik'] = false;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function deleteCustomer(
        CurrentPasswordRequest $currentPasswordRequest,
        CustomerService $customerService
    ) {
        $this->resetErrorBag();
        $userName = $this->user->full_name;
        $currentPasswordRequest->validate($this->input);
        $deleteCustomer = $customerService->deleteCustomer($this->user, $this->input['deleteOnMikrotik']);
        if ($deleteCustomer['success']) {
            $message = trans('customer.alert.customer-delete-detail', ['customer' => $userName]);
            $this->success_notification(trans('customer.alert.success'), $message);
        } else {
            $this->error_notification(trans('customer.alert.failed'), $deleteCustomer['message']);
        }

        $this->closeModal();
    }

    public function closeModal()
    {
        $this->deleteCustomerModal = false;
        $this->dispatch('refresh-customer-list');
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.delete-customer');
    }
}
