<?php

namespace App\Livewire\Admin\Customers\Modal;

use App\Models\User;
use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Services\CustomerPaketService;
use App\Http\Requests\CurrentPasswordRequest;

class DisableCustomer extends Component
{
    use NotificationTrait;
    public $disableCustomerModal = false;
    public $user;
    public $input = [];
    private CustomerPaketService $customerPaketService;
    public function boot(CustomerPaketService $customerPaketService)
    {
        $this->customerPaketService = $customerPaketService;
    }


    #[On('disable-customer-modal')]
    public function showDisableCustomerModal(User $user)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
        $this->disableCustomerModal = true;
        $this->user = $user;
         } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    /**
     * Disable Customer after validate user
     */
    public function disableCustomer(CurrentPasswordRequest $request)
    {
        $this->resetErrorBag();
        $request->validate($this->input);
        if ($this->user->disabled) {
            $this->user->forceFill([
                'disabled' => false
            ])->save();
             $this->success_notification(trans('customer.alert.enable-successfully'),  trans('customer.alert.customer-enable-detail', ['customer' => $this->user->full_name]));
             $this->closeModal();
        } else {

            $disabled['success'] = true;
            foreach ($this->user->customer_pakets as $customer_paket) {
                DB::beginTransaction();
                $this->customerPaketService->updateStatusCustomerPaket($customer_paket, 'suspended');
                DB::commit();
            }

            if ($disabled['success']) {
                $this->user->forceFill([
                    'disabled' => true
                ])->save();
                $this->warning_notification(trans('customer.alert.disable-successfully'), trans('customer.alert.customer-disable-detail', ['customer' => $this->user->full_name]));
                $this->closeModal();
            } else {
                $this->error_notification('Failed!', $disabled['message']);
            }
        }
    }

    public function closeModal()
    {
        $this->disableCustomerModal = false;
        $this->dispatch('refresh-customer-list');
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.disable-customer');
    }
}
