<?php

namespace App\Livewire\Admin\Customers\Modal;

use App\Models\User;
use App\Models\Address;
use Livewire\Component;
use App\Models\UserAddress;
use Livewire\Attributes\On;
use Illuminate\Support\Carbon;
use Illuminate\Validation\Rule;
use App\Traits\NotificationTrait;
use App\Services\User\UserService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Jantinnerezo\LivewireAlert\Facades\LivewireAlert;
use App\Http\Requests\Customers\UpdateUserStepTwoRequest;
use App\Http\Requests\Customers\UpdateUserStepThreeRequest;
use App\Http\Requests\Customers\CreateCustomerStepOneRequest;

class EditCustomerModal extends Component
{
    use NotificationTrait;
    public $editCustomerModal = false;
    public $user;
    public $input = [];
    public $currentStep = 1;
    public $changeInstallationAddress = false;
    public $changeBillingAddress = false;
    public $country, $province, $city, $district, $subdistrict;

    #[On('edit-customer-modal')]
    public function showEditCustomerModal(User $user)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->currentStep = 0;
            $this->reset();
            $this->editCustomerModal = true;
            $this->user = $user;
            $this->input['first_name'] = $this->user->first_name;
            $this->input['last_name'] = $this->user->last_name;
            $this->input['gender'] = $this->user->user_customer->gender ?? '';
            $this->input['dob'] = $this->user->user_customer->dob ? Carbon::parse($this->user->user_customer->dob)->format('Y-m-d') : null;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    protected $listeners = [
        'countryUpdated' => 'setCountry',
        'provinceUpdated' => 'setProvince',
        'cityUpdated' => 'setCity',
        'districtUpdated' => 'setDistrict',
        'subdistrictUpdated' => 'setSubdistrict',
    ];
    public function setCountry($object)
    {
        $this->country = Address::find($object['value']);
        $this->province = null;
        $this->city = null;
        $this->district = null;
        $this->subdistrict = null;
    }

    public function setProvince($object)
    {
        $this->province = Address::find($object['value']);
    }
    public function setCity($object)
    {
        $this->city = Address::find($object['value']);
    }
    public function setDistrict($object)
    {
        $this->district = Address::find($object['value']);
    }
    public function setSubdistrict($object)
    {
        $this->subdistrict = Address::find($object['value']);
    }

    public function firstStepSubmit()
    {
        (new CreateCustomerStepOneRequest())->validate($this->input);
        $this->currentStep = 2;
        $userAddress = $this->user->user_address;
        if ($userAddress) {
            $this->country = Address::whereName($userAddress->country)->first();
            if ($this->country) {
                request()['country'] = $this->country->id;
                $this->province = Address::whereAddressId($this->country->id)->whereName($userAddress->province)->first();
                if ($this->province) {
                    request()['province'] = $this->province->id;
                    $this->city = Address::whereAddressId($this->province->id)->whereName($userAddress->city)->first();
                    if ($this->city) {
                        request()['city'] = $this->city->id;
                        $this->district = Address::whereAddressId($this->city->id)->whereName($userAddress->district)->first();
                        if ($this->district) {
                            request()['district'] = $this->district->id;
                            $this->subdistrict = Address::whereAddressId($this->district->id)->whereName($userAddress->subdistrict)->first();
                            if ($this->subdistrict) {
                                request()['subdistrict'] = $this->subdistrict->id;
                            }
                        }
                    }
                }
            }
            $this->input['address'] = $this->user->user_address->address;
            $this->input['phone'] = $this->user->user_address->phone;
        } else {
            $userAddress = new UserAddress();
        }

        // }
    }

    public function secondStepSubmit()
    {
        $this->input = array_merge($this->input, [
            'country' => $this->country->name ?? '',
            'province' => $this->province->name ?? '',
            'city' => $this->city->name ?? '',
            'district' => $this->district->name ?? '',
            'subdistrict' => $this->subdistrict->name ?? ''
        ]);
        // $this->input['phone'] =  $this->internationalPhoneNumberFormat($this->input['phone']);
        (new UpdateUserStepTwoRequest())->validate($this->user->user_address, $this->input);
        foreach ($this->user->customer_pakets as $customer_paket) {
            if ($this->changeInstallationAddress) {
                Validator::make($this->input, [
                    'phone' => ['nullable', 'regex:/^([0-9\s\+\(\)]*)$/', 'min:9', 'max:14', Rule::unique('customer_paket_addresses')->ignore($customer_paket->id, 'customer_paket_id')],
                ])->validate();
            }
            if ($this->changeBillingAddress) {
                Validator::make($this->input, [
                    'phone' => ['nullable', 'regex:/^([0-9\s\+\(\)]*)$/', 'min:9', 'max:14', Rule::unique('customer_paket_addresses')->ignore($customer_paket->id, 'customer_paket_id')],
                ])->validate();
            }
        }

        $this->input['role'] = 'customer';
        $this->input['email'] = $this->user->email;
        $this->currentStep = 3;
    }

    public function updateCustomerInformation()
    {
        (new UpdateUserStepThreeRequest())->validate($this->user, $this->input);
        DB::beginTransaction();
        (new UserService())->updateUserCustomer($this->user, $this->input, $this->changeInstallationAddress, $this->changeBillingAddress);
        DB::commit();

        $this->dispatch('refresh-customer-list');
        LivewireAlert::title('Update Success!')
            ->text('Update customer successfully')
            ->position('top-end')
            ->toast()
            ->status('success')
            ->show();
        $this->closeModal();
    }

    public function back($step)
    {
        $this->currentStep = $step;
    }

    public function closeModal()
    {
        $this->editCustomerModal = false;
        $this->dispatch('refresh-customer-list');
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.edit-customer-modal');
    }
}
