<?php

namespace App\Livewire\Admin\Customers\Modal;

use App\Models\User;
use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class EditName extends Component
{
    use NotificationTrait;
    public $editNameModal = false;
    public $input = [];
    public $user;

    #[On('edit-name-modal')]
    public function showEditNameModal(User $user)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->input = array_merge([
                //
            ], $user->withoutRelations()->toArray());
            $this->user = $user;
            $this->editNameModal = true;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function closeModal()
    {
        $this->editNameModal = false;
        $this->dispatch('refresh-customer-list');
    }

    public function editName()
    {
        Validator::make($this->input, [
            'first_name' => ['required', 'string', 'min:2', 'max:15'],
            'last_name' => ['nullable', 'string', 'min:2', 'max:40'],
        ], [
            'first_name.required' => __('customer.validation-error-message.first-name-required'),
            'first_name.min' => __('customer.validation-error-message.first-name-min'),
            'first_name.max' => __('customer.validation-error-message.first-name-max'),
            'last_name.min' => __('customer.validation-error-message.last-name-min'),
            'last_name.max' => __('customer.validation-error-message.last-name-max'),
        ])->validate();

        $this->user->forceFill([
            'first_name' => $this->input['first_name'],
            'last_name' => $this->input['last_name']
        ])->save();
        $this->closeModal();
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.edit-name');
    }
}
