<?php

namespace App\Livewire\Admin\Customers\Modal;

use App\Models\User;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Services\CustomerService;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\DB;
use App\Services\GeneralLogServices;
use Illuminate\Support\Facades\Auth;

class RestoreCustomer extends Component
{
    use NotificationTrait;
    public $restoreCustomerModal = false;
    public $user;
    public $input = [];

    #[On('restore-customer-modal')]
    public function showRestoreCustomerModal($user)
    {
        if (Auth::user()->can('customer action') || Auth::user()->hasRole('admin')) {
            $this->reset();
            $this->user = User::withTrashed()->findOrFail($user);
            $this->restoreCustomerModal = true;
            $this->input['restoreOnMikrotik'] = true;
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function restoredCustomer(CustomerService $customerService, GeneralLogServices $generalLogServices)
    {
        DB::beginTransaction();
        try {
            $customerService->restoreCustomer($this->user, $this->input['restoreOnMikrotik']);
            $generalLogServices->admin_action($generalLogServices::RESTORE_CUSTOMER, "Restore customer " . $this->user->full_name);
            DB::commit();

            $this->success_notification('Restore Success!', 'Restore customer successfully');
            $this->dispatch('refresh-deleted-customer-list');
        } catch (\Exception $e) {
            DB::rollBack();
            $this->error_notification('Restore Failed!', $e->getMessage());
        }

        $this->restoreCustomerModal = false;
    }

    public function render()
    {
        return view('livewire.admin.customers.modal.restore-customer');
    }
}
