<?php

namespace App\Livewire\Admin\Mikrotiks\Modal;

use Livewire\Component;
use App\Models\Websystem;
use Livewire\Attributes\On;
use App\Services\PaketService;
use App\Models\Servers\Mikrotik;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Auth;
use App\Support\CollectionPagination;
use Illuminate\Support\Facades\Validator;

class ExportPaketModal extends Component
{
    use NotificationTrait;
    public $exportPaketModal = false;
    public $input = [];
    public $mikrotiks;
    public $fromMikrotik;
    public $toMikrotik;
    public $maxProfile = 0;
    public $countDifferentProfile = 0;
    public $online  = false;
    private PaketService $paketService;

    public function __construct()
    {
        $this->paketService = new PaketService;
    }


    #[On('show-export-paket-modal')]
    public function showExportPaketModal(Mikrotik $mikrotik)
    {
        if (Auth::user()->can('mikrotik action') || Auth::user()->hasRole('admin')) {
            $this->reset();
            $this->exportPaketModal  = true;
            $this->fromMikrotik = $mikrotik;
            $this->mikrotiks = Mikrotik::whereDisabled('false')->orderBy('name')->get();
        } else {
            $this->error_notification('Unauthorized', 'You dont have permission.');
        }
    }

    public function updatedInputSelectedServer($value)
    {
        $this->toMikrotik = Mikrotik::find($value);
        if ($this->toMikrotik) {
            try {
                $paketProfiles = $this->paketService->neededExportProfiles($this->fromMikrotik, $this->toMikrotik);
                $this->countDifferentProfile = count($paketProfiles);
                if (env('QUEUE_CONNECTION') == 'sync') {
                    $paketProfiles =   (new CollectionPagination($paketProfiles))->collectionPaginate(Websystem::first()->max_process);
                }
                $this->maxProfile = count($paketProfiles);
                $this->online = true;
            } catch (\Exception $e) {
                $this->online = false;
                $this->notification('Failed', $e->getMessage(), 'error');
            }
        } else {
            $this->countDifferentProfile = 0;
            $this->maxProfile = 0;
        }
    }

    public function exportPaket()
    {
        Validator::make($this->input, [
            'selectedServer' => ['required'],
        ])->validate();

        try {
            $this->paketService->exportPaketsToMikrotik($this->fromMikrotik, $this->toMikrotik);
            $message = trans('mikrotik.alert.export-profiles-in-progress', ['countProfile' => $this->countDifferentProfile, 'mikrotik' => $this->toMikrotik->name]);
            $this->notification(trans('mikrotik.alert.export-profiles'), $message, 'success');
        } catch (\Exception $e) {
            $this->notification('Failed', $e->getMessage(), 'error');
        }
        $this->exportPaketModal = false;
    }

    public function render()
    {
        return view('livewire.admin.mikrotiks.modal.export-paket-modal');
    }
}
