<?php

namespace App\Livewire\Admin\Settings\Address\Modal;

use App\Models\Address;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use App\Http\Requests\CurrentPasswordRequest;

class DeleteAddress extends Component
{
    use NotificationTrait;
    public $deleteAddressModal;
    public $address;
    public $input = [];

    #[On('delete-address-modal')]
    public function show_delete_address_modal(Address $address)
    {
        $this->address = $address;
        $this->deleteAddressModal = true;

    }

     public function deleteAddress(CurrentPasswordRequest $currentPasswordRequest)
     {
        $currentPasswordRequest->validate($this->input);
        $this->address->delete();
        $this->deleteAddressModal = false;
        $this->dispatch('refresh-address-list');
        $this->notification('Success', 'Delete '.$this->address->name.' successfully.', 'success');
     }
    public function render()
    {
        return view('livewire.admin.settings.address.modal.delete-address');
    }
}
