<?php

namespace App\Livewire\Admin\Settings\Address\Modal;

use App\Models\Address;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Validator;

class EditAddress extends Component
{
    use NotificationTrait;
    public $editAddressModal;
    public $address;
    public $input = [];

    #[On('edit-address-modal')]
    public function show_delete_address_modal(Address $address)
    {
        $this->address = $address;
        $this->editAddressModal = true;
        $this->input['name'] = $address->name;

    }

     public function updateAddress()
     {
        Validator::make($this->input, [
            'name' => ['required', 'string'],
            'current_password' => ['required', 'string', 'current_password:web'],
        ], [
            'current_password.required' => __('customer.validation-error-message.current-password-required'),
        ])->validate();

        $originalName = $this->address->name;
        $this->address->update([
            'name' => $this->input['name']
        ]);
        $this->notification('Success', 'Update '.$originalName. ' to '.$this->address->name.' successfully.', 'success');
        $this->editAddressModal = false;
        $this->dispatch('refresh-address-list');

     }
    public function render()
    {
        return view('livewire.admin.settings.address.modal.edit-address');
    }
}
