<?php

namespace App\Livewire\Admin\Users\Modal;

use App\Models\Address;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Services\User\UserService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;
use Jantinnerezo\LivewireAlert\Facades\LivewireAlert;
use App\Http\Requests\Customers\CreateCustomerStepOneRequest;
use App\Http\Requests\Customers\CreateCustomerStepTwoRequest;
use App\Http\Requests\Customers\CreateCustomerStepThreeRequest;

class CreateNewUserModal extends Component
{
    public $addUserModal = false;
    public $userSelect;
    public $input = [];
    public $currentStep = 1;
    public $country, $province, $city, $district, $subdistrict;

    protected $listeners = [
        'countryUpdated' => 'setCountry',
        'provinceUpdated' => 'setProvince',
        'cityUpdated' => 'setCity',
        'districtUpdated' => 'setDistrict',
        'subdistrictUpdated' => 'setSubdistrict',
    ];
    public function setCountry($object)
    {
        $this->country = Address::find($object['value']);
    }
    public function setProvince($object)
    {
        $this->province = Address::find($object['value']);
    }
    public function setCity($object)
    {
        $this->city = Address::find($object['value']);
    }
    public function setDistrict($object)
    {
        $this->district = Address::find($object['value']);
    }
    public function setSubdistrict($object)
    {
        $this->subdistrict = Address::find($object['value']);
    }
    /**
     * Add or Edit User Modal
     */
    #[On('add-user-modal')]
    public function showAddUserModal()
    {
        $this->addUserModal = true;
    }

    public function firstStepSubmit()
    {
        $this->resetErrorBag();
        (new CreateCustomerStepOneRequest())->validate($this->input);
        $this->currentStep = 2;
    }

    public function secondStepSubmit()
    {
        $this->input = array_merge($this->input, [
            'country' => $this->country->name ?? '',
            'province' => $this->province->name ?? '',
            'city' => $this->city->name ?? '',
            'district' => $this->district->name ?? '',
            'subdistrict' => $this->subdistrict->name ?? '',
            'phone' => $this->input['phone'] ?? null
        ]);
        //$this->input['phone'] =  $this->input['phone'] ?? null;
        $this->resetErrorBag();
        (new CreateCustomerStepTwoRequest())->validate($this->input);
        $this->currentStep = 3;
    }

    public function addUser()
    {
        $this->resetErrorBag();
        (new CreateCustomerStepThreeRequest())->validate($this->input);
        DB::beginTransaction();
        try {
            $user = (new UserService())->addUserAdmin($this->input);
            DB::commit();
            LivewireAlert::title(trans('user.alert.user-created'))
                ->text(trans('user.alert.user-created-successfully', ['user' => $user->full_name]))
                ->position('top-end')
                ->toast()
                ->status('success')
                ->show();
            $this->closeAddUserModal();
        } catch (\Exception $e) {
            LivewireAlert::title(trans('Failed'))
                ->text($e->getMessage())
                ->position('top-end')
                ->toast()
                ->status('error')
                ->show();
        }
    }

    public function back($step)
    {
        $this->currentStep = $step;
    }

    /**
     * Close add user modal
     */
    #[On('close-add-user-modal')]
    public function closeAddUserModal()
    {
        $this->dispatch('refresh-user-list');
        $this->currentStep = 0;
        $this->addUserModal = false;
        $this->reset();
    }

    public function render()
    {
        return view('livewire.admin.users.modal.create-new-user-modal');
    }
}
