<?php

namespace App\Livewire\Admin\Users;

use App\Models\User;
use Livewire\Component;
use App\Models\UserAddress;
use Livewire\Attributes\On;
use App\Exports\UsersExport;
use Livewire\WithPagination;
use Livewire\Attributes\Title;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class UsersManagement extends Component
{
    use WithPagination;
    #[Title('User Management')]
    //Short by
    public $sortField = 'full_name';
    public $sortDirection = 'asc';
    protected $queryString = ['sortField', 'sortDirection'];
    //Search
    public $search_name_or_email = '';
    public $search_address = '';
    public $search_gender = '';
    public $search_subdistrict = '';
    public $search_district = '';
    public $search_city = '';
    public $search_province = '';
    // Pagination
    public $perPage = 25;
    //dispatch
    public $alert_title, $alert_message;
    public $first_name, $last_name, $address, $email, $phone;
    //public $state = [];
    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection == 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection = 'asc';
        }
        $this->sortField = $field;
    }

    /**
     * Alert when user successfully disable or enable
     */
    #[On('user-disable')]
    public function alert(User $model)
    {
        if ($model->disabled) {
            $this->alert_title = trans('user.alert.disable-successfully');
            $this->alert_message = trans('user.alert.user-disable', ['user' => $model->full_name]);
        } else {
            $this->alert_title = trans('user.alert.enable-successfully');
            $this->alert_message = trans('user.alert.user-enable', ['user' => $model->full_name]);
        }
        $this->dispatch('updated');
    }

    /**
     * Export all user
     */
    public function exportUser()
    {
        //  return Excel::download(new UsersExport, 'users.xlsx');
    }

    #[On('refresh-user-list')]
    public function render()
    {
        $users = User::join('user_addresses', 'user_addresses.user_id', '=', 'users.id')
            ->join('user_admins', 'user_admins.user_id', '=', 'users.id')
            ->select(
                //  "*",
                "users.*",
                "user_addresses.id as address_id",
                DB::raw("CONCAT(users.first_name,' ',COALESCE(users.last_name, '')) as full_name"),
            )
            ->when($this->search_name_or_email, function ($builder) {
                $builder->where(function ($builder) {
                    $sql = "CONCAT(users.first_name,' ',COALESCE(users.last_name,''))  like ?";
                    $builder->whereRaw($sql,  "%" . $this->search_name_or_email . "%")
                        ->orWhere('email', 'like', '%' . $this->search_name_or_email . '%');
                });
            })
            ->when($this->search_address, function ($builder) {
                $sql = "CONCAT(user_addresses.address, ' ', user_addresses.subdistrict, ' ', user_addresses.district, ' ', user_addresses.city, ' ', user_addresses.province, ' ', user_addresses.country)  like ?";
                $builder->whereRaw($sql,  "%" . $this->search_address . "%");
            })
            ->when($this->search_gender, function ($builder) {
                $builder->where(function ($builder) {
                    $builder->where('gender', $this->search_gender);
                });
            })
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate($this->perPage);
        return view('livewire.admin.users.users-management', [
            'users' => $users
        ]);
    }
}
