<?php

namespace App\Livewire\Admin\WhatsappGateway;

use App\Traits\NotificationTrait;
use Livewire\Component;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\API\WhatsappGateway;
use App\Services\WhatsappGateway\GatewayApiService;
use Illuminate\Validation\Rules\Password as PasswordRule;

class AccountSettings extends Component
{
    use NotificationTrait;
    public $username, $titleMessage = 'ERROR', $errorMessage;
    public $notFound = false;
    public $isError = false;
    public $input = [];

    public function mount()
    {
        try {
            $response = (new GatewayApiService())->getRequest(WhatsappGateway::ACCOUNT_SETTINGS);
            if ($response['success']){
                $user = $response['payload']['data']['user'];
                    $this->input['email'] = $user['email'] ?? null;
                    $this->username = $user['username'] ?? null;
                    $this->dispatch('account-updated');
            } else {
                $this->isError = true;
                $this->error_notification('Failed!', $response['message']);
            }
        } catch (\Exception $e) {
            $this->error_notification('Failed!', $e->getMessage());
            $this->redirect(route('managements.whatsapp_gateway'), navigate: true);
        }
    }


    public function update_account()
    {
        Validator::make(
            $this->input,
            [
                'email' => ['required', 'string', 'lowercase', 'email', 'max:255'],
                'password' => ['nullable', 'string', PasswordRule::defaults(), 'confirmed'],
            ]
        )->validate();

        $response = (new GatewayApiService())->updateRequest(WhatsappGateway::ACCOUNT_SETTINGS, $this->username, $this->input);

        if ($response['success']) {
            $this->success_notification('Success', $response['payload']['message']);
        } else {
                $this->error_notification('Failed', $response['message']);
        }
    }
    public function render()
    {
        return view('livewire.admin.whatsapp-gateway.account-settings');
    }
}
