<?php

namespace App\Livewire\Admin\WhatsappGateway\Modal;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Traits\StandardPhoneNumber;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\API\WhatsappGateway;
use App\Services\WhatsappGateway\GatewayApiService;
use App\Traits\NotificationTrait;

class AddDevice extends Component
{
    use StandardPhoneNumber, NotificationTrait;
    public $addDeviceModal = false;
    public $number;
    public $input = [];

    #[On('show-add-device-modal')]
    public function addDeviceModal()
    {
        $this->reset();
        $this->addDeviceModal = true;
    }

    public function addNumber()
    {

        Validator::make(
            $this->input,
            [
                'device_name' => 'required',
                'body' => 'required|numeric',
                'description' => ['nullable', 'string', 'min:10', 'max:255'],
            ],
            [
                'body.required' => 'The number is required',
                'body.numeric' => 'The number must be a number.',
            ]
        )->validate();

        $this->input['body'] = $this->internationalPhoneNumberFormat($this->input['body']);
        $response = (new GatewayApiService())->addRequest(WhatsappGateway::DEVICES, $this->input);

        if ($response['success']) {
            $this->closeModal();
            $this->success_notification('Success', $response['payload']['message']);
        } else {
            $this->error_notification('Failed!', $response['message']);
        }
    }


    public function closeModal()
    {
        $this->addDeviceModal = false;
        $this->dispatch('refresh-devices-list');
    }


    public function render()
    {
        return view('livewire.admin.whatsapp-gateway.modal.add-device');
    }
}
