<?php

namespace App\Livewire\Admin\WhatsappGateway\Modal;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Http\Requests\CurrentPasswordRequest;

class ConfirmDelete extends Component
{
    public $confirmDeleteModal = false;
    public $input = [];
    public $id;

    #[On('confirm-delete-modal')]
    public function show_confirm_delete_modal($id)
    {
        $this->confirmDeleteModal = true;
        $this->id = $id;
    }

    public function delete_this(CurrentPasswordRequest $request)
    {
        $request->validate($this->input);
        $this->dispatch('confirm-delete', $this->id);
        $this->confirmDeleteModal = false;
    }

    public function render()
    {
        return view('livewire.admin.whatsapp-gateway.modal.confirm-delete');
    }
}
