<?php

namespace App\Livewire\Admin\WhatsappGateway\Modal;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Http\Requests\CurrentPasswordRequest;

class ConfirmDeleteAll extends Component
{
    public $confirmDeleteAllModal = false;
    public $input = [];

    #[On('confirm-delete-all-modal')]
    public function show_confirm_delete_all_modal()
    {
        $this->confirmDeleteAllModal = true;
    }

    public function delete_all(CurrentPasswordRequest $request)
    {
        $request->validate($this->input);
        $this->dispatch('confirm-delete-all');
        $this->confirmDeleteAllModal = false;
    }

    public function render()
    {
        return view('livewire.admin.whatsapp-gateway.modal.confirm-delete-all');
    }
}
