<?php

namespace App\Livewire\Admin\WhatsappGateway\Modal;

use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Http\Controllers\API\WhatsappGateway;
use App\Http\Requests\CurrentPasswordRequest;
use App\Services\WhatsappGateway\GatewayApiService;

class DeleteDevice extends Component
{
    use NotificationTrait;
    public $deleteDeviceModal = false;
    public $number;
    public $input = [];

    #[On('show-delete-device-modal')]
    public function deleteDeviceModal($number)
    {
        $this->deleteDeviceModal = true;
        $this->number = $number;
    }

    public function deleteDevice(CurrentPasswordRequest $request )
    {
        $request->validate($this->input);
        $response = (new GatewayApiService())->deleteRequest(WhatsappGateway::DEVICES, $this->number, $this->input);

        if ($response['success']) {
            $this->success_notification('Success', $response['payload']['message'] ?? 'Delete device successfully');
            $this->closeModal();
        } else {

                $this->error_notification('Failed!', $response['message'] ?? 'Unknow error');
        }
    }

    public function closeModal()
    {
        $this->deleteDeviceModal = false;
        $this->dispatch('refresh-devices-list');
    }

    public function render()
    {
        return view('livewire.admin.whatsapp-gateway.modal.delete-device');
    }
}
