<?php

namespace App\Livewire\Admin\WhatsappGateway\Modal;

use App\Traits\NotificationTrait;
use Livewire\Component;
use Livewire\Attributes\On;
use App\Http\Controllers\API\WhatsappGateway;
use App\Services\WhatsappGateway\GatewayApiService;
use App\Http\Requests\WhatsappGateway\SubscriptionRequest;


class EditSubscription extends Component
{
    use NotificationTrait;
    public $editSubscriptionModal = false;
    public $subscription;
    public $subscriptionPlans = [];
    public $paymentMethods = [];
    public $products = [];
    public $input = [];
    public $order;
    public $user;
    public $inctructions;
    public $descriptionProduct;
    public $currentStep = 0;

    #[On('show-add-subscription-modal')]
    public function addSubscriptionModal()
    {
        $this->editSubscriptionModal = true;
        $response = (new GatewayApiService())->createRequest(WhatsappGateway::SUBSCRIPTION);

        if ($response['success']) {
            $this->currentStep = 1;
            $data = $response['payload']['data'];
            $this->subscriptionPlans = $data['subscription_plans'];
            $this->products = $data['products'];
            $this->paymentMethods = $data['payment_methods'];
        } else {
            $this->error_notification('Failed', $response['message']);
        }
    }

    #[On('show-edit-subscription-modal')]
    public function editSubscriptionModal($subscription = null)
    {
        $this->editSubscriptionModal = true;
        $response = (new GatewayApiService())->showRequest(WhatsappGateway::SUBSCRIPTION, $subscription);

        if ($response['success']) {
            $payload = $response['payload'];

            if (collect($payload['data']['order'])->count()) {
                $this->currentStep = 2;
                $this->input['paymentCode'] = $payload['data']['order']['pay_code'];
                $this->order = $payload['data']['order'];
            } else {
                $this->currentStep = 1;
                $data = $payload['data'];
                $this->subscription = $data['subscription'];
                $this->subscriptionPlans = $data['subscription_plans'];
                $this->products = $data['products'];
                $this->paymentMethods = $data['payment_methods'];
                if ($this->subscription) {
                    $this->input['product'] = $this->subscription['product'];
                    $this->input['renewal_period'] = $this->subscription['renewal_period'];
                }
            }
        } else {
            $this->error_notification('Failed!', $response['message']);
        }
    }

    /*
    public function updatedInputProduct($value)
    {
        $this->input['renewal_period'] = '';
        $this->input['payment_method'] = '';
        $this->paymentMethods = [];
        if ($value) {
            $subscriptionPlans =  Cache::remember('subscription-plan', now()->addMinutes(15), function () {
                return (new GatewayApiService())->getRequest(WhatsappGateway::SUBSCRIPTION_PLAN);
            });
            $result = $subscriptionPlans['result'];
            if ($result['success']) {
                $this->subscriptionPlans = $result['data']['subscription_plans'];
            } else {
                $this->notification('Error', $result['message'], 'error');
            }
        }
        $product = collect($this->products)->where('id', $value)->first();
        $this->descriptionProduct = $product['description'] ?? 'Please select product!';
    }

    public function updatedInputRenewalPeriod($value)
    {
        $this->input['payment_method'] = '';
        if ($value) {
            $paymentMethods =  Cache::remember('payment-methods', now()->addMinutes(15), function () {
                return (new GatewayApiService())->getRequest(WhatsappGateway::PAYMENT_METHODE);
            });
            $result = $paymentMethods['result'];
            if ($result['success']) {
                $this->paymentMethods = $result['data']['payment_methods'];
            } else {
                $this->notification('Error', $result['message'], 'error');
            }
        }
    }
        */

    public function addSubscription(SubscriptionRequest $subscriptionRequest)
    {
        $subscriptionRequest->validate($this->input);
        $response = (new GatewayApiService())->addRequest(WhatsappGateway::SUBSCRIPTION,  $this->input);
        if ($response['success']) {
            $this->currentStep = 2;
            $data = $response['payload']['data'];
            $this->input['paymentCode'] = $data['order']['pay_code'];
            $this->order = $data['order'];
        } else {
            $this->error_notification('Failed', $response['message']);
        }
    }

    public function updateSubscription(SubscriptionRequest $subscriptionRequest)
    {
        $subscriptionRequest->validate($this->input);
        $response = (new GatewayApiService())->updateRequest(WhatsappGateway::SUBSCRIPTION, env('API_USERNAME'), $this->input);

        if ($response['success']) {
            if ($response['status_code'] === 204) {
                $this->success_notification('Success', 'Tidak ada perubahan layanan.');
                $this->closeModal();
            } else {
                $this->currentStep = 2;
                $this->input['paymentCode'] = $response['payload']['data']['order']['pay_code'];
                $this->order = $response['payload']['data']['order'];
                //$this->notification('success', 'Tidak ada perubahan layanan.', 'success');
                $this->success_notification('Success', 'Update subscription successfully.');
            }
        } else {
            $this->error_notification('Failed!', $response['message']);
        }
    }

    public function instructions()
    {
        //dd($this->order);
        $this->inctructions = json_decode($this->order['instructions'], true);
        $this->currentStep = 3;
    }

    public function back($step)
    {
        $this->currentStep = $step;
    }
    public function closeModal()
    {
        $this->editSubscriptionModal = false;
        $this->dispatch('refresh-subscription-management');
    }

    public function render()
    {
        return view('livewire.admin.whatsapp-gateway.modal.edit-subscription');
    }
}
