<?php

namespace App\Livewire\Auth\Register;

use Livewire\Component;
use Illuminate\Http\Request;
use Livewire\Attributes\Layout;
use App\Services\User\UserService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Auth\Events\Registered;
use App\Livewire\Actions\Users\UserAction;
use App\Http\Requests\Customers\CreateCustomerStepThreeRequest;

class RegisterStepThree extends Component
{
    public $input = [];
    public $sessionRegister;

    public function mount(Request $request)
    {
        //if(!$request->session()->get('register.stepOne')) $this->redirect(route('register.stepOne', absolute: false), navigate: true);
        if (!$request->session()->get('register.stepTwo')) $this->back_step_two();
        $sessionRegisterStepThree = $request->session()->get('register.stepThree');
        if ($sessionRegisterStepThree) {
            $this->input = array_merge([
                'email' => $sessionRegisterStepThree['email'] ?? '',
                'password' => $sessionRegisterStepThree['password'] ?? '',
                'password_confirmation' => $sessionRegisterStepThree['password_confirmation'] ?? '',
            ]);
        }
    }

    public function register_user(Request $request)
    {
        // dd('test');
        // $this->input['phone'] =  $this->input['phone'] ?? null;
        $this->input['role'] = 'customer';
        (new CreateCustomerStepThreeRequest())->validate($this->input);
        
        DB::beginTransaction();
        try {
            $inputStepOne = $request->session()->get('register.stepOne');
            $inputStepTwo = $request->session()->get('register.stepTwo');
            $inputStepThree = $request->session()->get('register.stepThree');
            $input = array_merge(
                $inputStepOne,
                $inputStepTwo,
                $inputStepThree
            );

            $user =  (new UserService())->addUserCustomer($input);
            DB::commit();
            $request->session()->flush();
            event(new Registered(($user)));
            Auth::login($user);
            //   $request->session()->forget('register');

            if (Auth::user()->hasRole('admin')) {
                $this->redirectIntended(default: route('dashboard', absolute: false), navigate: true);
            } elseif (Auth::user()->hasRole('customer')) {
                $this->redirectIntended(default: route('customer.dashboard', absolute: false), navigate: true);
            } else {
                $this->redirectIntended(default: route('login', absolute: false), navigate: true);
            }
        } catch (\Exception $e) {
            DB::rollBack();
            dd($e->getMessage());
        }
    }

    public function back_step_two()
    {
        session()->put('register.stepThree', $this->input);
        $this->redirect(route('register.steptwo', absolute: false), navigate: true);
    }

    #[Layout('components.layouts.auth')]
    public function render()
    {
        return view('livewire.auth.register.register-step-three');
    }
}
