<?php

namespace App\Livewire;

use Carbon\Carbon;
use App\Models\Address;
use Livewire\Component;
use App\Models\Websystem;
use Illuminate\Support\Str;
use App\Jobs\ImportAddressJob;
use App\Models\Billings\Payment;
use App\Models\Servers\Mikrotik;
use App\Traits\CustomerPaketTrait;
use App\Models\Customers\CustomerPaket;
use App\Services\Billings\DeadlineService;
use App\Services\Mikrotiks\MikrotikService;
use App\Services\Mikrotiks\MikrotikPppService;
use Illuminate\Console\Command;

class Test extends Component
{
    use CustomerPaketTrait;
    private MikrotikPppService $mikrotikPppService;
    private MikrotikService $mikrotikService;
    private DeadlineService $deadlineService;
    public function boot(MikrotikPppService $mikrotikPppService, MikrotikService $mikrotikService)
    {
        $this->mikrotikPppService = $mikrotikPppService;
        $this->mikrotikService = $mikrotikService;
        $this->deadlineService =  new DeadlineService;
    }

    private function getAddress($url)
    {
        $data =  file_get_contents($url);
        return json_decode($data, true);
    }

    public function render()
    {
        /*
        $mikrotik = Mikrotik::first();
        // $pppSecret = $this->mikrotikPppService->getPppSecretByName($mikrotik, 'sugiyo-rejosari654');

        $allUserSecret = $this->mikrotikService->getAllUserSecrets($mikrotik);
        foreach (collect($allUserSecret)->where('name', 'sugiyo-titang') as $userSecret) {
            // $comment = empty($userSecret['comment'] ?? false) ? null : $userSecret['comment'];
            $input = array_merge([
                'comment' => empty($userSecret['comment'] ?? false) ? null : $userSecret['comment']
            ]);
            $startDate = $activationDate = Carbon::now();
            $expiredDate = $this->deadlineService->convertSubscription('monthly', $startDate);
            if (!is_null($input['comment'])) {
                $commentUnpayment = Websystem::first()->comment_unpayment;
                $removed = Str::remove($commentUnpayment . '_', $input['comment']);
                $replaced = Str::replace('_', '-', $removed);
                $activationDate = Carbon::parse($replaced);

                $dayActivationDate = Carbon::parse($activationDate)->format('d');
                $startDate = Carbon::now()->setDay((int) $dayActivationDate);
                $expiredDate = $this->deadlineService->convertSubscription($input['renewal_period'], $startDate);
            }

            dd('Start Date '.$startDate.' Expired Date '.$expiredDate.' Activation Date '.$activationDate);

        }*/
        //  if (cache()->get('processing_import_address')) {
        //      $this->warn('Processing import address is already running');
        //      return Command::FAILURE;
        // }

        // cache()->put('processing_import_address', true, 60); // Lock for 60 minutes

        try {

            Address::truncate();
          //  dispatch(new ImportAddressJob())->onQueue('default');
        } catch (\Exception $e) {
            cache()->forget('processing_auto_isolir');
            $this->error("Error processing auto isolir: " . $e->getMessage());
            return Command::FAILURE;
        }
        return view('livewire.test');
    }
}
