<?php

namespace App\Models\Servers;

use Spatie\Sluggable\HasSlug;
use App\Models\Servers\Mikrotik;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MikrotikMonitoring extends Model
{
    use SoftDeletes;
   // use HasSlug;

    public $guarded = [];

    //public function getSlugOptions(): SlugOptions
  //  {
   //     return SlugOptions::create()
   //         ->generateSlugsFrom('name')
   //         ->saveSlugsTo('slug')
    //        ->doNotGenerateSlugsOnUpdate();
   // }
    public function getRouteKeyName(): string
    {
        return 'slug';
    }

    public function mikrotik(): BelongsTo
    {
        return $this->belongsTo(Mikrotik::class);
    }
}
