<?php

namespace App\Notifications;

use GuzzleHttp\Client;
use App\Channels\Whatsapp;
use Illuminate\Bus\Queueable;
use App\Channels\WhatsappChannel;
use App\Channels\WhatsappMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Http\Controllers\API\WhatsappGateway;
use Illuminate\Notifications\Messages\MailMessage;

class TestWhatsapp extends Notification
{
    use Queueable;

    protected string $apikey;
    protected string $to;
    protected string $from;
    protected string $message;
    protected string $dryrun = 'no';
    protected string $baseUrl;
    protected string $endpoint;


    /**
     * Create a new notification instance.
     */
    public function __construct()
    {
        $this->apikey = env('API_CLIENT_MESSAGE');
        $this->baseUrl = config('wa-griyanet.server_url');
        $this->endpoint = WhatsappGateway::SEND_MESSAGE;
    }

    /**
     * Get the notification channels.
     */
    public function via(object $notifiable): string
    {
        return WhatsappChannel::class;
    }

    /**

     * Get the voice representation of the notification.

     */

    public function toWhatsapp(object $notifiable)
    {
        $whatsapp = new WhatsappMessage;
        // Replace with your telephone number :-)
        $whatsapp->to($this->to)->from($this->from)->message('Congrulation, whatsapp gateway successfully connected.')->send();
    }
}
